"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.sql_inputs import SqlInputs, SqlInputsModel
from snowflake.core.cortex.analyst_service._generated.models.tableau_input import TableauInput, TableauInputModel
from snowflake.core.cortex.analyst_service._generated.models.tds_input import TdsInput, TdsInputModel


class PreSelectionRequest(BaseModel):
    """A model object representing the PreSelectionRequest resource.

    Constructs an object of type PreSelectionRequest with the provided properties.

    Parameters
    __________
    tds_source : list[TdsInput]

    warehouse : str
        Warehouse name to use for processing.
    sql_source : SqlInputs, optional

    tableau_input : TableauInput, optional

    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    tds_source: List[TdsInput]

    sql_source: Optional[SqlInputs] = None

    warehouse: StrictStr

    tableau_input: Optional[TableauInput] = None

    experimental: Optional[StrictStr] = None

    __properties = ["tds_source", "sql_source", "warehouse", "tableau_input", "experimental"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PreSelectionRequest:
        """Create an instance of PreSelectionRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in tds_source (list)
        _items = []
        if self.tds_source:
            for _item in self.tds_source:
                if _item:
                    _items.append(_item.to_dict())
            _dict["tds_source"] = _items

        # override the default output from pydantic by calling `to_dict()` of sql_source
        if self.sql_source:
            _dict["sql_source"] = self.sql_source.to_dict()

        # override the default output from pydantic by calling `to_dict()` of tableau_input
        if self.tableau_input:
            _dict["tableau_input"] = self.tableau_input.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PreSelectionRequest:
        """Create an instance of PreSelectionRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PreSelectionRequest.parse_obj(obj)

        _obj = PreSelectionRequest.parse_obj(
            {
                "tds_source": [TdsInput.from_dict(_item) for _item in obj.get("tds_source")]
                if obj.get("tds_source") is not None
                else None,
                "sql_source": SqlInputs.from_dict(obj.get("sql_source")) if obj.get("sql_source") is not None else None,
                "warehouse": obj.get("warehouse"),
                "tableau_input": TableauInput.from_dict(obj.get("tableau_input"))
                if obj.get("tableau_input") is not None
                else None,
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class PreSelectionRequestModel:
    def __init__(
        self,
        tds_source: list[TdsInput],
        warehouse: str,
        # optional properties
        sql_source: Optional[SqlInputs] = None,
        tableau_input: Optional[TableauInput] = None,
        experimental: Optional[str] = None,
    ):
        """A model object representing the PreSelectionRequest resource.

        Constructs an object of type PreSelectionRequest with the provided properties.

        Parameters
        __________
        tds_source : list[TdsInput]

        warehouse : str
            Warehouse name to use for processing.
        sql_source : SqlInputs, optional

        tableau_input : TableauInput, optional

        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.tds_source = tds_source
        self.sql_source = sql_source
        self.warehouse = warehouse
        self.tableau_input = tableau_input
        self.experimental = experimental

    __properties = ["tds_source", "sql_source", "warehouse", "tableau_input", "experimental"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PreSelectionRequest(
            tds_source=[x._to_model() for x in self.tds_source] if self.tds_source is not None else None,
            sql_source=self.sql_source._to_model() if self.sql_source is not None else None,
            warehouse=self.warehouse,
            tableau_input=self.tableau_input._to_model() if self.tableau_input is not None else None,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> PreSelectionRequestModel:
        return PreSelectionRequestModel(
            tds_source=[TdsInputModel._from_model(x) for x in model.tds_source] if model.tds_source else None,
            sql_source=SqlInputsModel._from_model(model.sql_source) if model.sql_source else None,
            warehouse=model.warehouse,
            tableau_input=TableauInputModel._from_model(model.tableau_input) if model.tableau_input else None,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PreSelectionRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PreSelectionRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PreSelectionRequestModel:
        """Create an instance of PreSelectionRequest from a dict.

        This method constructs a PreSelectionRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PreSelectionRequest
            A PreSelectionRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PreSelectionRequest.from_dict(obj))


PreSelectionRequest._model_class = PreSelectionRequestModel
