"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class StreamingError(BaseModel):
    """A model object representing the StreamingError resource.

    Constructs an object of type StreamingError with the provided properties.

    Parameters
    __________
    message : str, optional
        A description of the error
    code : str, optional
        The Snowflake error code categorizing the error
    request_id : str, optional
        Unique request ID
    """

    message: Optional[StrictStr] = None

    code: Optional[StrictStr] = None

    request_id: Optional[StrictStr] = None

    __properties = ["message", "code", "request_id"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamingError:
        """Create an instance of StreamingError from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingError:
        """Create an instance of StreamingError from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamingError.parse_obj(obj)

        _obj = StreamingError.parse_obj(
            {
                "message": obj.get("message"),
                "code": obj.get("code"),
                "request_id": obj.get("request_id"),
            }
        )

        return _obj


class StreamingErrorModel:
    def __init__(
        self,  # optional properties
        message: Optional[str] = None,
        code: Optional[str] = None,
        request_id: Optional[str] = None,
    ):
        """A model object representing the StreamingError resource.

        Constructs an object of type StreamingError with the provided properties.

        Parameters
        __________
        message : str, optional
            A description of the error
        code : str, optional
            The Snowflake error code categorizing the error
        request_id : str, optional
            Unique request ID
        """
        self.message = message
        self.code = code
        self.request_id = request_id

    __properties = ["message", "code", "request_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamingError(
            message=self.message,
            code=self.code,
            request_id=self.request_id,
        )

    @classmethod
    def _from_model(cls, model) -> StreamingErrorModel:
        return StreamingErrorModel(
            message=model.message,
            code=model.code,
            request_id=model.request_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StreamingError.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamingError object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingErrorModel:
        """Create an instance of StreamingError from a dict.

        This method constructs a StreamingError object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamingError
            A StreamingError object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamingError.from_dict(obj))


StreamingError._model_class = StreamingErrorModel
