"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import BaseModel, StrictStr


class TableauAuth(BaseModel):
    """A model object representing the TableauAuth resource.

    Constructs an object of type TableauAuth with the provided properties.

    Parameters
    __________
    secret_fqn : str
        The fully qualified name of the secret containing the Tableau PAT
    server_url : str
        The Tableau server name to send requests to
    """

    secret_fqn: StrictStr

    server_url: StrictStr

    __properties = ["secret_fqn", "server_url"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableauAuth:
        """Create an instance of TableauAuth from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableauAuth:
        """Create an instance of TableauAuth from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableauAuth.parse_obj(obj)

        _obj = TableauAuth.parse_obj(
            {
                "secret_fqn": obj.get("secret_fqn"),
                "server_url": obj.get("server_url"),
            }
        )

        return _obj


class TableauAuthModel:
    def __init__(
        self,
        secret_fqn: str,
        server_url: str,
        # optional properties
    ):
        """A model object representing the TableauAuth resource.

        Constructs an object of type TableauAuth with the provided properties.

        Parameters
        __________
        secret_fqn : str
            The fully qualified name of the secret containing the Tableau PAT
        server_url : str
            The Tableau server name to send requests to
        """
        self.secret_fqn = secret_fqn
        self.server_url = server_url

    __properties = ["secret_fqn", "server_url"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableauAuth(
            secret_fqn=self.secret_fqn,
            server_url=self.server_url,
        )

    @classmethod
    def _from_model(cls, model) -> TableauAuthModel:
        return TableauAuthModel(
            secret_fqn=model.secret_fqn,
            server_url=model.server_url,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TableauAuth.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableauAuth object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableauAuthModel:
        """Create an instance of TableauAuth from a dict.

        This method constructs a TableauAuth object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableauAuth
            A TableauAuth object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableauAuth.from_dict(obj))


TableauAuth._model_class = TableauAuthModel
