"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel

from snowflake.core.cortex.analyst_service._generated.models.tableau_server_files import (
    TableauServerFiles,
    TableauServerFilesModel,
)
from snowflake.core.cortex.analyst_service._generated.models.tableau_stage_files import (
    TableauStageFiles,
    TableauStageFilesModel,
)


class TableauInput(BaseModel):
    """A model object representing the TableauInput resource.

    Constructs an object of type TableauInput with the provided properties.

    Parameters
    __________
    stage_files : TableauStageFiles, optional

    server_files : TableauServerFiles, optional
    """

    stage_files: Optional[TableauStageFiles] = None

    server_files: Optional[TableauServerFiles] = None

    __properties = ["stage_files", "server_files"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableauInput:
        """Create an instance of TableauInput from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of stage_files
        if self.stage_files:
            _dict["stage_files"] = self.stage_files.to_dict()

        # override the default output from pydantic by calling `to_dict()` of server_files
        if self.server_files:
            _dict["server_files"] = self.server_files.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableauInput:
        """Create an instance of TableauInput from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableauInput.parse_obj(obj)

        _obj = TableauInput.parse_obj(
            {
                "stage_files": TableauStageFiles.from_dict(obj.get("stage_files"))
                if obj.get("stage_files") is not None
                else None,
                "server_files": TableauServerFiles.from_dict(obj.get("server_files"))
                if obj.get("server_files") is not None
                else None,
            }
        )

        return _obj


class TableauInputModel:
    def __init__(
        self,  # optional properties
        stage_files: Optional[TableauStageFiles] = None,
        server_files: Optional[TableauServerFiles] = None,
    ):
        """A model object representing the TableauInput resource.

        Constructs an object of type TableauInput with the provided properties.

        Parameters
        __________
        stage_files : TableauStageFiles, optional

        server_files : TableauServerFiles, optional
        """
        self.stage_files = stage_files
        self.server_files = server_files

    __properties = ["stage_files", "server_files"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableauInput(
            stage_files=self.stage_files._to_model() if self.stage_files is not None else None,
            server_files=self.server_files._to_model() if self.server_files is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> TableauInputModel:
        return TableauInputModel(
            stage_files=TableauStageFilesModel._from_model(model.stage_files) if model.stage_files else None,
            server_files=TableauServerFilesModel._from_model(model.server_files) if model.server_files else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TableauInput.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableauInput object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableauInputModel:
        """Create an instance of TableauInput from a dict.

        This method constructs a TableauInput object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableauInput
            A TableauInput object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableauInput.from_dict(obj))


TableauInput._model_class = TableauInputModel
