"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.tableau_integration import (
    TableauIntegration,
    TableauIntegrationModel,
)


class TableauServerFiles(BaseModel):
    """A model object representing the TableauServerFiles resource.

    Constructs an object of type TableauServerFiles with the provided properties.

    Parameters
    __________
    tableau_urls : list[str], optional

    integration : TableauIntegration, optional
    """

    tableau_urls: Optional[List[StrictStr]] = None

    integration: Optional[TableauIntegration] = None

    __properties = ["tableau_urls", "integration"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableauServerFiles:
        """Create an instance of TableauServerFiles from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of integration
        if self.integration:
            _dict["integration"] = self.integration.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableauServerFiles:
        """Create an instance of TableauServerFiles from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableauServerFiles.parse_obj(obj)

        _obj = TableauServerFiles.parse_obj(
            {
                "tableau_urls": obj.get("tableau_urls"),
                "integration": TableauIntegration.from_dict(obj.get("integration"))
                if obj.get("integration") is not None
                else None,
            }
        )

        return _obj


class TableauServerFilesModel:
    def __init__(
        self,  # optional properties
        tableau_urls: Optional[list[str]] = None,
        integration: Optional[TableauIntegration] = None,
    ):
        """A model object representing the TableauServerFiles resource.

        Constructs an object of type TableauServerFiles with the provided properties.

        Parameters
        __________
        tableau_urls : list[str], optional

        integration : TableauIntegration, optional
        """
        self.tableau_urls = tableau_urls
        self.integration = integration

    __properties = ["tableau_urls", "integration"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableauServerFiles(
            tableau_urls=self.tableau_urls,
            integration=self.integration._to_model() if self.integration is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> TableauServerFilesModel:
        return TableauServerFilesModel(
            tableau_urls=model.tableau_urls,
            integration=TableauIntegrationModel._from_model(model.integration) if model.integration else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TableauServerFiles.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableauServerFiles object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableauServerFilesModel:
        """Create an instance of TableauServerFiles from a dict.

        This method constructs a TableauServerFiles object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableauServerFiles
            A TableauServerFiles object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableauServerFiles.from_dict(obj))


TableauServerFiles._model_class = TableauServerFilesModel
