"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class TdsInput(BaseModel):
    """A model object representing the TdsInput resource.

    Constructs an object of type TdsInput with the provided properties.

    Parameters
    __________
    tds_stage_path : str
        TDS file stage path
    tds_file_content : str, optional
        TDS file raw contents
    """

    tds_stage_path: StrictStr

    tds_file_content: Optional[StrictStr] = None

    __properties = ["tds_stage_path", "tds_file_content"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TdsInput:
        """Create an instance of TdsInput from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TdsInput:
        """Create an instance of TdsInput from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TdsInput.parse_obj(obj)

        _obj = TdsInput.parse_obj(
            {
                "tds_stage_path": obj.get("tds_stage_path"),
                "tds_file_content": obj.get("tds_file_content"),
            }
        )

        return _obj


class TdsInputModel:
    def __init__(
        self,
        tds_stage_path: str,
        # optional properties
        tds_file_content: Optional[str] = None,
    ):
        """A model object representing the TdsInput resource.

        Constructs an object of type TdsInput with the provided properties.

        Parameters
        __________
        tds_stage_path : str
            TDS file stage path
        tds_file_content : str, optional
            TDS file raw contents
        """
        self.tds_stage_path = tds_stage_path
        self.tds_file_content = tds_file_content

    __properties = ["tds_stage_path", "tds_file_content"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TdsInput(
            tds_stage_path=self.tds_stage_path,
            tds_file_content=self.tds_file_content,
        )

    @classmethod
    def _from_model(cls, model) -> TdsInputModel:
        return TdsInputModel(
            tds_stage_path=model.tds_stage_path,
            tds_file_content=model.tds_file_content,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TdsInput.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TdsInput object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TdsInputModel:
        """Create an instance of TdsInput from a dict.

        This method constructs a TdsInput object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TdsInput
            A TdsInput object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TdsInput.from_dict(obj))


TdsInput._model_class = TdsInputModel
