"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictInt, StrictStr


class TokenInfo(BaseModel):
    """A model object representing the TokenInfo resource.

    Constructs an object of type TokenInfo with the provided properties.

    Parameters
    __________
    token : str, optional

    expiration_seconds : int, optional
    """

    token: Optional[StrictStr] = None

    expiration_seconds: Optional[StrictInt] = None

    __properties = ["token", "expiration_seconds"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TokenInfo:
        """Create an instance of TokenInfo from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TokenInfo:
        """Create an instance of TokenInfo from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TokenInfo.parse_obj(obj)

        _obj = TokenInfo.parse_obj(
            {
                "token": obj.get("token"),
                "expiration_seconds": obj.get("expiration_seconds"),
            }
        )

        return _obj


class TokenInfoModel:
    def __init__(
        self,  # optional properties
        token: Optional[str] = None,
        expiration_seconds: Optional[int] = None,
    ):
        """A model object representing the TokenInfo resource.

        Constructs an object of type TokenInfo with the provided properties.

        Parameters
        __________
        token : str, optional

        expiration_seconds : int, optional
        """
        self.token = token
        self.expiration_seconds = expiration_seconds

    __properties = ["token", "expiration_seconds"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TokenInfo(
            token=self.token,
            expiration_seconds=self.expiration_seconds,
        )

    @classmethod
    def _from_model(cls, model) -> TokenInfoModel:
        return TokenInfoModel(
            token=model.token,
            expiration_seconds=model.expiration_seconds,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TokenInfo.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TokenInfo object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TokenInfoModel:
        """Create an instance of TokenInfo from a dict.

        This method constructs a TokenInfo object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TokenInfo
            A TokenInfo object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TokenInfo.from_dict(obj))


TokenInfo._model_class = TokenInfoModel
