"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictInt, StrictStr


class VerifiedQuery(BaseModel):
    """A model object representing the VerifiedQuery resource.

    Constructs an object of type VerifiedQuery with the provided properties.

    Parameters
    __________
    name : str, optional
        A name for this verified query. Mainly used for display purposes.
    question : str, optional
        The question being answered.
    sql : str, optional
        The correct SQL query for answering the question.
    verified_at : int, optional
        Timestamp at which the query was last verified - measures in seconds since epoch, in UTC.
    verified_by : str, optional
        Name of the person who verified this query.
    """

    name: Optional[StrictStr] = None

    question: Optional[StrictStr] = None

    sql: Optional[StrictStr] = None

    verified_at: Optional[StrictInt] = None

    verified_by: Optional[StrictStr] = None

    __properties = ["name", "question", "sql", "verified_at", "verified_by"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VerifiedQuery:
        """Create an instance of VerifiedQuery from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> VerifiedQuery:
        """Create an instance of VerifiedQuery from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VerifiedQuery.parse_obj(obj)

        _obj = VerifiedQuery.parse_obj(
            {
                "name": obj.get("name"),
                "question": obj.get("question"),
                "sql": obj.get("sql"),
                "verified_at": obj.get("verified_at"),
                "verified_by": obj.get("verified_by"),
            }
        )

        return _obj


class VerifiedQueryModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        question: Optional[str] = None,
        sql: Optional[str] = None,
        verified_at: Optional[int] = None,
        verified_by: Optional[str] = None,
    ):
        """A model object representing the VerifiedQuery resource.

        Constructs an object of type VerifiedQuery with the provided properties.

        Parameters
        __________
        name : str, optional
            A name for this verified query. Mainly used for display purposes.
        question : str, optional
            The question being answered.
        sql : str, optional
            The correct SQL query for answering the question.
        verified_at : int, optional
            Timestamp at which the query was last verified - measures in seconds since epoch, in UTC.
        verified_by : str, optional
            Name of the person who verified this query.
        """
        self.name = name
        self.question = question
        self.sql = sql
        self.verified_at = verified_at
        self.verified_by = verified_by

    __properties = ["name", "question", "sql", "verified_at", "verified_by"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return VerifiedQuery(
            name=self.name,
            question=self.question,
            sql=self.sql,
            verified_at=self.verified_at,
            verified_by=self.verified_by,
        )

    @classmethod
    def _from_model(cls, model) -> VerifiedQueryModel:
        return VerifiedQueryModel(
            name=model.name,
            question=model.question,
            sql=model.sql,
            verified_at=model.verified_at,
            verified_by=model.verified_by,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a VerifiedQuery.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the VerifiedQuery object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> VerifiedQueryModel:
        """Create an instance of VerifiedQuery from a dict.

        This method constructs a VerifiedQuery object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        VerifiedQuery
            A VerifiedQuery object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(VerifiedQuery.from_dict(obj))


VerifiedQuery._model_class = VerifiedQueryModel
