"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional, Union

from pydantic import BaseModel, StrictFloat, StrictInt

from snowflake.core.cortex.analyst_service._generated.models.verified_query import VerifiedQuery, VerifiedQueryModel


class VerifiedQuerySuggestion(BaseModel):
    """A model object representing the VerifiedQuerySuggestion resource.

    Constructs an object of type VerifiedQuerySuggestion with the provided properties.

    Parameters
    __________
    score : float, optional
        Score of the suggestion, higher is better.
    vq_to_add : VerifiedQuery, optional

    vq_to_remove : VerifiedQuery, optional
    """

    score: Optional[Union[StrictFloat, StrictInt]] = None

    vq_to_add: Optional[VerifiedQuery] = None

    vq_to_remove: Optional[VerifiedQuery] = None

    __properties = ["score", "vq_to_add", "vq_to_remove"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VerifiedQuerySuggestion:
        """Create an instance of VerifiedQuerySuggestion from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of vq_to_add
        if self.vq_to_add:
            _dict["vq_to_add"] = self.vq_to_add.to_dict()

        # override the default output from pydantic by calling `to_dict()` of vq_to_remove
        if self.vq_to_remove:
            _dict["vq_to_remove"] = self.vq_to_remove.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> VerifiedQuerySuggestion:
        """Create an instance of VerifiedQuerySuggestion from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VerifiedQuerySuggestion.parse_obj(obj)

        _obj = VerifiedQuerySuggestion.parse_obj(
            {
                "score": obj.get("score"),
                "vq_to_add": VerifiedQuery.from_dict(obj.get("vq_to_add"))
                if obj.get("vq_to_add") is not None
                else None,
                "vq_to_remove": VerifiedQuery.from_dict(obj.get("vq_to_remove"))
                if obj.get("vq_to_remove") is not None
                else None,
            }
        )

        return _obj


class VerifiedQuerySuggestionModel:
    def __init__(
        self,  # optional properties
        score: Optional[float] = None,
        vq_to_add: Optional[VerifiedQuery] = None,
        vq_to_remove: Optional[VerifiedQuery] = None,
    ):
        """A model object representing the VerifiedQuerySuggestion resource.

        Constructs an object of type VerifiedQuerySuggestion with the provided properties.

        Parameters
        __________
        score : float, optional
            Score of the suggestion, higher is better.
        vq_to_add : VerifiedQuery, optional

        vq_to_remove : VerifiedQuery, optional
        """
        self.score = score
        self.vq_to_add = vq_to_add
        self.vq_to_remove = vq_to_remove

    __properties = ["score", "vq_to_add", "vq_to_remove"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return VerifiedQuerySuggestion(
            score=self.score,
            vq_to_add=self.vq_to_add._to_model() if self.vq_to_add is not None else None,
            vq_to_remove=self.vq_to_remove._to_model() if self.vq_to_remove is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> VerifiedQuerySuggestionModel:
        return VerifiedQuerySuggestionModel(
            score=model.score,
            vq_to_add=VerifiedQueryModel._from_model(model.vq_to_add) if model.vq_to_add else None,
            vq_to_remove=VerifiedQueryModel._from_model(model.vq_to_remove) if model.vq_to_remove else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a VerifiedQuerySuggestion.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the VerifiedQuerySuggestion object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> VerifiedQuerySuggestionModel:
        """Create an instance of VerifiedQuerySuggestion from a dict.

        This method constructs a VerifiedQuerySuggestion object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        VerifiedQuerySuggestion
            A VerifiedQuerySuggestion object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(VerifiedQuerySuggestion.from_dict(obj))


VerifiedQuerySuggestion._model_class = VerifiedQuerySuggestionModel
