"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class Warning(BaseModel):
    """A model object representing the Warning resource.

    Constructs an object of type Warning with the provided properties.

    Parameters
    __________
    message : str, optional
        A human-readable message describing the warning
    """

    message: Optional[StrictStr] = None

    __properties = ["message"]

    class Config:  # noqa: D106
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Warning:
        """Create an instance of Warning from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Warning:
        """Create an instance of Warning from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Warning.parse_obj(obj)

        _obj = Warning.parse_obj(
            {
                "message": obj.get("message"),
            }
        )

        return _obj


class WarningModel:
    def __init__(
        self,  # optional properties
        message: Optional[str] = None,
    ):
        """A model object representing the Warning resource.

        Constructs an object of type Warning with the provided properties.

        Parameters
        __________
        message : str, optional
            A human-readable message describing the warning
        """
        self.message = message

    __properties = ["message"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Warning(
            message=self.message,
        )

    @classmethod
    def _from_model(cls, model) -> WarningModel:
        return WarningModel(
            message=model.message,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Warning.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Warning object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> WarningModel:
        """Create an instance of Warning from a dict.

        This method constructs a Warning object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Warning
            A Warning object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Warning.from_dict(obj))


Warning._model_class = WarningModel
