"""
Cortex Chat API.

OpenAPI 3.0 specification for the Cortex Chat API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, Optional

from pydantic import BaseModel, StrictInt, StrictStr


class ChatRequestSearchServicesInner(BaseModel):
    """A model object representing the ChatRequestSearchServicesInner resource.

    Constructs an object of type ChatRequestSearchServicesInner with the provided properties.

    Parameters
    __________
    name : str
        The name of the search service.
    max_results : int, optional
        The number of search results used in LLM prompt.
    title_column : str, optional
        The title of the document.
    id_column : str, optional
        The ID of the document.
    filter : object, optional
        Filter query.
    experimental : object, optional
        reserved
    """

    name: StrictStr

    max_results: Optional[StrictInt] = None

    title_column: Optional[StrictStr] = None

    id_column: Optional[StrictStr] = None

    filter: Optional[Dict[str, Any]] = None

    experimental: Optional[Dict[str, Any]] = None

    __properties = ["name", "max_results", "title_column", "id_column", "filter", "experimental"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatRequestSearchServicesInner:
        """Create an instance of ChatRequestSearchServicesInner from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ChatRequestSearchServicesInner:
        """Create an instance of ChatRequestSearchServicesInner from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ChatRequestSearchServicesInner.parse_obj(obj)

        _obj = ChatRequestSearchServicesInner.parse_obj(
            {
                "name": obj.get("name"),
                "max_results": obj.get("max_results"),
                "title_column": obj.get("title_column"),
                "id_column": obj.get("id_column"),
                "filter": obj.get("filter"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class ChatRequestSearchServicesInnerModel:
    def __init__(
        self,
        name: str,
        # optional properties
        max_results: Optional[int] = None,
        title_column: Optional[str] = None,
        id_column: Optional[str] = None,
        filter: Optional[object] = None,
        experimental: Optional[object] = None,
    ):
        """A model object representing the ChatRequestSearchServicesInner resource.

        Constructs an object of type ChatRequestSearchServicesInner with the provided properties.

        Parameters
        __________
        name : str
            The name of the search service.
        max_results : int, optional
            The number of search results used in LLM prompt.
        title_column : str, optional
            The title of the document.
        id_column : str, optional
            The ID of the document.
        filter : object, optional
            Filter query.
        experimental : object, optional
            reserved
        """
        self.name = name
        self.max_results = max_results
        self.title_column = title_column
        self.id_column = id_column
        self.filter = filter
        self.experimental = experimental

    __properties = ["name", "max_results", "title_column", "id_column", "filter", "experimental"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ChatRequestSearchServicesInner(
            name=self.name,
            max_results=self.max_results,
            title_column=self.title_column,
            id_column=self.id_column,
            filter=self.filter,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> ChatRequestSearchServicesInnerModel:
        return ChatRequestSearchServicesInnerModel(
            name=model.name,
            max_results=model.max_results,
            title_column=model.title_column,
            id_column=model.id_column,
            filter=model.filter,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ChatRequestSearchServicesInner.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ChatRequestSearchServicesInner object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ChatRequestSearchServicesInnerModel:
        """Create an instance of ChatRequestSearchServicesInner from a dict.

        This method constructs a ChatRequestSearchServicesInner object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ChatRequestSearchServicesInner
            A ChatRequestSearchServicesInner object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ChatRequestSearchServicesInner.from_dict(obj))


ChatRequestSearchServicesInner._model_class = ChatRequestSearchServicesInnerModel
