"""
Cortex Embed API.

OpenAPI 3.0 specification for the Cortex Embed REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Union

from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr, field_validator


class EmbedResponseDataInner(BaseModel):
    """A model object representing the EmbedResponseDataInner resource.

    Constructs an object of type EmbedResponseDataInner with the provided properties.

    Parameters
    __________
    object : str
        Type of the embedding object
    embedding : list[List[float]]
        Nested array of floating-point numbers representing the embedding vector
    index : int
        Index of the embedding in the input array
    """

    object: StrictStr

    embedding: List[List[Union[StrictFloat, StrictInt]]]

    index: StrictInt

    __properties = ["object", "embedding", "index"]

    @field_validator("object")
    def object_validate_enum(cls, v):
        if v not in ("embedding"):
            raise ValueError("must validate the enum values ('embedding')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EmbedResponseDataInner:
        """Create an instance of EmbedResponseDataInner from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedResponseDataInner:
        """Create an instance of EmbedResponseDataInner from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EmbedResponseDataInner.parse_obj(obj)

        _obj = EmbedResponseDataInner.parse_obj(
            {
                "object": obj.get("object"),
                "embedding": obj.get("embedding"),
                "index": obj.get("index"),
            }
        )

        return _obj


class EmbedResponseDataInnerModel:
    def __init__(
        self,
        object: str,
        embedding: list[List[float]],
        index: int,
        # optional properties
    ):
        """A model object representing the EmbedResponseDataInner resource.

        Constructs an object of type EmbedResponseDataInner with the provided properties.

        Parameters
        __________
        object : str
            Type of the embedding object
        embedding : list[List[float]]
            Nested array of floating-point numbers representing the embedding vector
        index : int
            Index of the embedding in the input array
        """
        self.object = object
        self.embedding = embedding
        self.index = index

    __properties = ["object", "embedding", "index"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return EmbedResponseDataInner(
            object=self.object,
            embedding=self.embedding,
            index=self.index,
        )

    @classmethod
    def _from_model(cls, model) -> EmbedResponseDataInnerModel:
        return EmbedResponseDataInnerModel(
            object=model.object,
            embedding=model.embedding,
            index=model.index,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a EmbedResponseDataInner.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the EmbedResponseDataInner object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedResponseDataInnerModel:
        """Create an instance of EmbedResponseDataInner from a dict.

        This method constructs a EmbedResponseDataInner object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        EmbedResponseDataInner
            A EmbedResponseDataInner object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(EmbedResponseDataInner.from_dict(obj))


EmbedResponseDataInner._model_class = EmbedResponseDataInnerModel
