"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr, field_validator


class CacheControl(BaseModel):
    """A model object representing the CacheControl resource.

    Constructs an object of type CacheControl with the provided properties.

    Parameters
    __________
    type : str, optional
        Identifies the type of cache control.
        “ephemeral” is the only supported cache type currently, which has a 5-minute lifetime.
    """

    type: Optional[StrictStr] = None

    __properties = ["type"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("ephemeral"):
            raise ValueError("must validate the enum values ('ephemeral')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CacheControl:
        """Create an instance of CacheControl from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CacheControl:
        """Create an instance of CacheControl from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CacheControl.parse_obj(obj)

        _obj = CacheControl.parse_obj(
            {
                "type": obj.get("type"),
            }
        )

        return _obj


class CacheControlModel:
    def __init__(
        self,  # optional properties
        type: Optional[str] = None,
    ):
        """A model object representing the CacheControl resource.

                Constructs an object of type CacheControl with the provided properties.

                Parameters
                __________
                type : str, optional
                    Identifies the type of cache control.
        “ephemeral” is the only supported cache type currently, which has a 5-minute lifetime.
        """
        self.type = type

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CacheControl(
            type=self.type,
        )

    @classmethod
    def _from_model(cls, model) -> CacheControlModel:
        return CacheControlModel(
            type=model.type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CacheControl.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CacheControl object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CacheControlModel:
        """Create an instance of CacheControl from a dict.

        This method constructs a CacheControl object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CacheControl
            A CacheControl object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CacheControl.from_dict(obj))


CacheControl._model_class = CacheControlModel
