"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import BaseModel, StrictInt


class CompleteRequestAnthropicThinking(BaseModel):
    """A model object representing the CompleteRequestAnthropicThinking resource.

    Constructs an object of type CompleteRequestAnthropicThinking with the provided properties.

    Parameters
    __________
    budget_tokens : int
        The budget for thinking tokens.
    """

    budget_tokens: StrictInt

    __properties = ["budget_tokens"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteRequestAnthropicThinking:
        """Create an instance of CompleteRequestAnthropicThinking from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestAnthropicThinking:
        """Create an instance of CompleteRequestAnthropicThinking from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompleteRequestAnthropicThinking.parse_obj(obj)

        _obj = CompleteRequestAnthropicThinking.parse_obj(
            {
                "budget_tokens": obj.get("budget_tokens"),
            }
        )

        return _obj


class CompleteRequestAnthropicThinkingModel:
    def __init__(
        self,
        budget_tokens: int,
        # optional properties
    ):
        """A model object representing the CompleteRequestAnthropicThinking resource.

        Constructs an object of type CompleteRequestAnthropicThinking with the provided properties.

        Parameters
        __________
        budget_tokens : int
            The budget for thinking tokens.
        """
        self.budget_tokens = budget_tokens

    __properties = ["budget_tokens"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CompleteRequestAnthropicThinking(
            budget_tokens=self.budget_tokens,
        )

    @classmethod
    def _from_model(cls, model) -> CompleteRequestAnthropicThinkingModel:
        return CompleteRequestAnthropicThinkingModel(
            budget_tokens=model.budget_tokens,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CompleteRequestAnthropicThinking.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CompleteRequestAnthropicThinking object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestAnthropicThinkingModel:
        """Create an instance of CompleteRequestAnthropicThinking from a dict.

        This method constructs a CompleteRequestAnthropicThinking object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CompleteRequestAnthropicThinking
            A CompleteRequestAnthropicThinking object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CompleteRequestAnthropicThinking.from_dict(obj))


CompleteRequestAnthropicThinking._model_class = CompleteRequestAnthropicThinkingModel
