"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr, field_validator


class CompleteRequestResponseFormat(BaseModel):
    """A model object representing the CompleteRequestResponseFormat resource.

    Constructs an object of type CompleteRequestResponseFormat with the provided properties.

    Parameters
    __________
    type : str, optional
        The response format type (e.g., "json").
    var_schema : object, optional
        The schema defining the structure of the response. If the `type` is "json", the `schema` field should contain a valid JSON schema.
    """

    type: Optional[StrictStr] = None

    var_schema: Optional[Dict[str, Any]] = Field(default=None, alias="schema")

    __properties = ["type", "schema"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("json"):
            raise ValueError("must validate the enum values ('json')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteRequestResponseFormat:
        """Create an instance of CompleteRequestResponseFormat from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestResponseFormat:
        """Create an instance of CompleteRequestResponseFormat from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompleteRequestResponseFormat.parse_obj(obj)

        _obj = CompleteRequestResponseFormat.parse_obj(
            {
                "type": obj.get("type"),
                "var_schema": obj.get("schema"),
            }
        )

        return _obj


class CompleteRequestResponseFormatModel:
    def __init__(
        self,  # optional properties
        type: Optional[str] = None,
        var_schema: Optional[object] = None,
    ):
        """A model object representing the CompleteRequestResponseFormat resource.

        Constructs an object of type CompleteRequestResponseFormat with the provided properties.

        Parameters
        __________
        type : str, optional
            The response format type (e.g., "json").
        var_schema : object, optional
            The schema defining the structure of the response. If the `type` is "json", the `schema` field should contain a valid JSON schema.
        """
        self.type = type
        self.var_schema = var_schema

    __properties = ["type", "schema"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CompleteRequestResponseFormat(
            type=self.type,
            var_schema=self.var_schema,
        )

    @classmethod
    def _from_model(cls, model) -> CompleteRequestResponseFormatModel:
        return CompleteRequestResponseFormatModel(
            type=model.type,
            var_schema=model.var_schema,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CompleteRequestResponseFormat.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CompleteRequestResponseFormat object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestResponseFormatModel:
        """Create an instance of CompleteRequestResponseFormat from a dict.

        This method constructs a CompleteRequestResponseFormat object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CompleteRequestResponseFormat
            A CompleteRequestResponseFormat object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CompleteRequestResponseFormat.from_dict(obj))


CompleteRequestResponseFormat._model_class = CompleteRequestResponseFormatModel
