"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictStr


class GetModelsResponse(BaseModel):
    """A model object representing the GetModelsResponse resource.

    Constructs an object of type GetModelsResponse with the provided properties.

    Parameters
    __________
    models : list[str], optional
    """

    models: Optional[List[StrictStr]] = None

    __properties = ["models"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetModelsResponse:
        """Create an instance of GetModelsResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GetModelsResponse:
        """Create an instance of GetModelsResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetModelsResponse.parse_obj(obj)

        _obj = GetModelsResponse.parse_obj(
            {
                "models": obj.get("models"),
            }
        )

        return _obj


class GetModelsResponseModel:
    def __init__(
        self,  # optional properties
        models: Optional[list[str]] = None,
    ):
        """A model object representing the GetModelsResponse resource.

        Constructs an object of type GetModelsResponse with the provided properties.

        Parameters
        __________
        models : list[str], optional
        """
        self.models = models

    __properties = ["models"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GetModelsResponse(
            models=self.models,
        )

    @classmethod
    def _from_model(cls, model) -> GetModelsResponseModel:
        return GetModelsResponseModel(
            models=model.models,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GetModelsResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GetModelsResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GetModelsResponseModel:
        """Create an instance of GetModelsResponse from a dict.

        This method constructs a GetModelsResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GetModelsResponse
            A GetModelsResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GetModelsResponse.from_dict(obj))


GetModelsResponse._model_class = GetModelsResponseModel
