"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr, field_validator

from snowflake.core.cortex.inference_service._generated.models.cache_control import CacheControl, CacheControlModel
from snowflake.core.cortex.inference_service._generated.models.image_details import ImageDetails, ImageDetailsModel


class Image(BaseModel):
    """A model object representing the Image resource.

    Constructs an object of type Image with the provided properties.

    Parameters
    __________
    type : str, optional

    details : ImageDetails, optional

    cache_control : CacheControl, optional
    """

    type: Optional[StrictStr] = None

    details: Optional[ImageDetails] = None

    cache_control: Optional[CacheControl] = None

    __properties = ["type", "details", "cache_control"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("image"):
            raise ValueError("must validate the enum values ('image')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Image:
        """Create an instance of Image from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict["details"] = self.details.to_dict()

        # override the default output from pydantic by calling `to_dict()` of cache_control
        if self.cache_control:
            _dict["cache_control"] = self.cache_control.to_dict()

        # set to None if cache_control (nullable) is None
        if self.cache_control is None:
            _dict["cache_control"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Image:
        """Create an instance of Image from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Image.parse_obj(obj)

        _obj = Image.parse_obj(
            {
                "type": obj.get("type"),
                "details": ImageDetails.from_dict(obj.get("details")) if obj.get("details") is not None else None,
                "cache_control": CacheControl.from_dict(obj.get("cache_control"))
                if obj.get("cache_control") is not None
                else None,
            }
        )

        return _obj


class ImageModel:
    def __init__(
        self,  # optional properties
        type: Optional[str] = None,
        details: Optional[ImageDetails] = None,
        cache_control: Optional[CacheControl] = None,
    ):
        """A model object representing the Image resource.

        Constructs an object of type Image with the provided properties.

        Parameters
        __________
        type : str, optional

        details : ImageDetails, optional

        cache_control : CacheControl, optional
        """
        self.type = type
        self.details = details
        self.cache_control = cache_control

    __properties = ["type", "details", "cache_control"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Image(
            type=self.type,
            details=self.details._to_model() if self.details is not None else None,
            cache_control=self.cache_control._to_model() if self.cache_control is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> ImageModel:
        return ImageModel(
            type=model.type,
            details=ImageDetailsModel._from_model(model.details) if model.details else None,
            cache_control=CacheControlModel._from_model(model.cache_control) if model.cache_control else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Image.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Image object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ImageModel:
        """Create an instance of Image from a dict.

        This method constructs a Image object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Image
            A Image object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Image.from_dict(obj))


Image._model_class = ImageModel
