"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel

from snowflake.core.cortex.inference_service._generated.models.streaming_anthropic_thinking import (
    StreamingAnthropicThinking,
    StreamingAnthropicThinkingModel,
)


class StreamingAnthropicOutput(BaseModel):
    """A model object representing the StreamingAnthropicOutput resource.

    Constructs an object of type StreamingAnthropicOutput with the provided properties.

    Parameters
    __________
    thinking : StreamingAnthropicThinking, optional
    """

    thinking: Optional[StreamingAnthropicThinking] = None

    __properties = ["thinking"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamingAnthropicOutput:
        """Create an instance of StreamingAnthropicOutput from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of thinking
        if self.thinking:
            _dict["thinking"] = self.thinking.to_dict()

        # set to None if thinking (nullable) is None
        if self.thinking is None:
            _dict["thinking"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingAnthropicOutput:
        """Create an instance of StreamingAnthropicOutput from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamingAnthropicOutput.parse_obj(obj)

        _obj = StreamingAnthropicOutput.parse_obj(
            {
                "thinking": StreamingAnthropicThinking.from_dict(obj.get("thinking"))
                if obj.get("thinking") is not None
                else None,
            }
        )

        return _obj


class StreamingAnthropicOutputModel:
    def __init__(
        self,  # optional properties
        thinking: Optional[StreamingAnthropicThinking] = None,
    ):
        """A model object representing the StreamingAnthropicOutput resource.

        Constructs an object of type StreamingAnthropicOutput with the provided properties.

        Parameters
        __________
        thinking : StreamingAnthropicThinking, optional
        """
        self.thinking = thinking

    __properties = ["thinking"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamingAnthropicOutput(
            thinking=self.thinking._to_model() if self.thinking is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> StreamingAnthropicOutputModel:
        return StreamingAnthropicOutputModel(
            thinking=StreamingAnthropicThinkingModel._from_model(model.thinking) if model.thinking else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StreamingAnthropicOutput.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamingAnthropicOutput object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingAnthropicOutputModel:
        """Create an instance of StreamingAnthropicOutput from a dict.

        This method constructs a StreamingAnthropicOutput object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamingAnthropicOutput
            A StreamingAnthropicOutput object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamingAnthropicOutput.from_dict(obj))


StreamingAnthropicOutput._model_class = StreamingAnthropicOutputModel
