"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class StreamingAnthropicThinking(BaseModel):
    """A model object representing the StreamingAnthropicThinking resource.

    Constructs an object of type StreamingAnthropicThinking with the provided properties.

    Parameters
    __________
    thinking : str, optional
        Thinking tokens generated during the model response.
        This field can also be used in the follow-up requests to continue the conversation.
    signature : str, optional
        The signature field is an opaque field and should not be interpreted or parsed.
        It should only be used for verifying that the thinking blocks were generated by that specific model.
    """

    thinking: Optional[StrictStr] = None

    signature: Optional[StrictStr] = None

    __properties = ["thinking", "signature"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamingAnthropicThinking:
        """Create an instance of StreamingAnthropicThinking from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # set to None if thinking (nullable) is None
        if self.thinking is None:
            _dict["thinking"] = None

        # set to None if signature (nullable) is None
        if self.signature is None:
            _dict["signature"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingAnthropicThinking:
        """Create an instance of StreamingAnthropicThinking from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamingAnthropicThinking.parse_obj(obj)

        _obj = StreamingAnthropicThinking.parse_obj(
            {
                "thinking": obj.get("thinking"),
                "signature": obj.get("signature"),
            }
        )

        return _obj


class StreamingAnthropicThinkingModel:
    def __init__(
        self,  # optional properties
        thinking: Optional[str] = None,
        signature: Optional[str] = None,
    ):
        """A model object representing the StreamingAnthropicThinking resource.

                Constructs an object of type StreamingAnthropicThinking with the provided properties.

                Parameters
                __________
                thinking : str, optional
                    Thinking tokens generated during the model response.
        This field can also be used in the follow-up requests to continue the conversation.

                signature : str, optional
                    The signature field is an opaque field and should not be interpreted or parsed.
        It should only be used for verifying that the thinking blocks were generated by that specific model.
        """
        self.thinking = thinking
        self.signature = signature

    __properties = ["thinking", "signature"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamingAnthropicThinking(
            thinking=self.thinking,
            signature=self.signature,
        )

    @classmethod
    def _from_model(cls, model) -> StreamingAnthropicThinkingModel:
        return StreamingAnthropicThinkingModel(
            thinking=model.thinking,
            signature=model.signature,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StreamingAnthropicThinking.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamingAnthropicThinking object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingAnthropicThinkingModel:
        """Create an instance of StreamingAnthropicThinking from a dict.

        This method constructs a StreamingAnthropicThinking object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamingAnthropicThinking
            A StreamingAnthropicThinking object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamingAnthropicThinking.from_dict(obj))


StreamingAnthropicThinking._model_class = StreamingAnthropicThinkingModel
