"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel

from snowflake.core.cortex.inference_service._generated.models.streaming_complete_response_data_event_choices_inner import (
    StreamingCompleteResponseDataEventChoicesInner,
    StreamingCompleteResponseDataEventChoicesInnerModel,
)


class StreamingCompleteResponseDataEvent(BaseModel):
    """A model object representing the StreamingCompleteResponseDataEvent resource.

    Constructs an object of type StreamingCompleteResponseDataEvent with the provided properties.

    Parameters
    __________
    choices : list[StreamingCompleteResponseDataEventChoicesInner], optional
    """

    choices: Optional[List[StreamingCompleteResponseDataEventChoicesInner]] = None

    __properties = ["choices"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamingCompleteResponseDataEvent:
        """Create an instance of StreamingCompleteResponseDataEvent from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in choices (list)
        _items = []
        if self.choices:
            for _item in self.choices:
                if _item:
                    _items.append(_item.to_dict())
            _dict["choices"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingCompleteResponseDataEvent:
        """Create an instance of StreamingCompleteResponseDataEvent from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamingCompleteResponseDataEvent.parse_obj(obj)

        _obj = StreamingCompleteResponseDataEvent.parse_obj(
            {
                "choices": [
                    StreamingCompleteResponseDataEventChoicesInner.from_dict(_item) for _item in obj.get("choices")
                ]
                if obj.get("choices") is not None
                else None,
            }
        )

        return _obj


class StreamingCompleteResponseDataEventModel:
    def __init__(
        self,  # optional properties
        choices: Optional[list[StreamingCompleteResponseDataEventChoicesInner]] = None,
    ):
        """A model object representing the StreamingCompleteResponseDataEvent resource.

        Constructs an object of type StreamingCompleteResponseDataEvent with the provided properties.

        Parameters
        __________
        choices : list[StreamingCompleteResponseDataEventChoicesInner], optional
        """
        self.choices = choices

    __properties = ["choices"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamingCompleteResponseDataEvent(
            choices=[x._to_model() for x in self.choices] if self.choices is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> StreamingCompleteResponseDataEventModel:
        return StreamingCompleteResponseDataEventModel(
            choices=[StreamingCompleteResponseDataEventChoicesInnerModel._from_model(x) for x in model.choices]
            if model.choices
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StreamingCompleteResponseDataEvent.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamingCompleteResponseDataEvent object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingCompleteResponseDataEventModel:
        """Create an instance of StreamingCompleteResponseDataEvent from a dict.

        This method constructs a StreamingCompleteResponseDataEvent object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamingCompleteResponseDataEvent
            A StreamingCompleteResponseDataEvent object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamingCompleteResponseDataEvent.from_dict(obj))


StreamingCompleteResponseDataEvent._model_class = StreamingCompleteResponseDataEventModel
