"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, Optional

from pydantic import BaseModel


class StreamingCompleteResponseDataEventChoicesInner(BaseModel):
    """A model object representing the StreamingCompleteResponseDataEventChoicesInner resource.

    Constructs an object of type StreamingCompleteResponseDataEventChoicesInner with the provided properties.

    Parameters
    __________
    delta : object, optional
    """

    delta: Optional[Dict[str, Any]] = None

    __properties = ["delta"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamingCompleteResponseDataEventChoicesInner:
        """Create an instance of StreamingCompleteResponseDataEventChoicesInner from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingCompleteResponseDataEventChoicesInner:
        """Create an instance of StreamingCompleteResponseDataEventChoicesInner from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamingCompleteResponseDataEventChoicesInner.parse_obj(obj)

        _obj = StreamingCompleteResponseDataEventChoicesInner.parse_obj(
            {
                "delta": obj.get("delta"),
            }
        )

        return _obj


class StreamingCompleteResponseDataEventChoicesInnerModel:
    def __init__(
        self,  # optional properties
        delta: Optional[object] = None,
    ):
        """A model object representing the StreamingCompleteResponseDataEventChoicesInner resource.

        Constructs an object of type StreamingCompleteResponseDataEventChoicesInner with the provided properties.

        Parameters
        __________
        delta : object, optional
        """
        self.delta = delta

    __properties = ["delta"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamingCompleteResponseDataEventChoicesInner(
            delta=self.delta,
        )

    @classmethod
    def _from_model(cls, model) -> StreamingCompleteResponseDataEventChoicesInnerModel:
        return StreamingCompleteResponseDataEventChoicesInnerModel(
            delta=model.delta,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StreamingCompleteResponseDataEventChoicesInner.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamingCompleteResponseDataEventChoicesInner object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingCompleteResponseDataEventChoicesInnerModel:
        """Create an instance of StreamingCompleteResponseDataEventChoicesInner from a dict.

        This method constructs a StreamingCompleteResponseDataEventChoicesInner object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamingCompleteResponseDataEventChoicesInner
            A StreamingCompleteResponseDataEventChoicesInner object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamingCompleteResponseDataEventChoicesInner.from_dict(obj))


StreamingCompleteResponseDataEventChoicesInner._model_class = StreamingCompleteResponseDataEventChoicesInnerModel
