"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class StreamingOpenAIReasoning(BaseModel):
    """A model object representing the StreamingOpenAIReasoning resource.

    Constructs an object of type StreamingOpenAIReasoning with the provided properties.

    Parameters
    __________
    summary : str, optional
        Reasoning summary tokens generated during the model response.
    encrypted_content : str, optional
        The encrypted_content field is an opaque field and should not be interpreted or parsed.
        It should only be used for verifying that the reasoning blocks were generated by that specific model.
    """

    summary: Optional[StrictStr] = None

    encrypted_content: Optional[StrictStr] = None

    __properties = ["summary", "encrypted_content"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamingOpenAIReasoning:
        """Create an instance of StreamingOpenAIReasoning from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # set to None if summary (nullable) is None
        if self.summary is None:
            _dict["summary"] = None

        # set to None if encrypted_content (nullable) is None
        if self.encrypted_content is None:
            _dict["encrypted_content"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingOpenAIReasoning:
        """Create an instance of StreamingOpenAIReasoning from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamingOpenAIReasoning.parse_obj(obj)

        _obj = StreamingOpenAIReasoning.parse_obj(
            {
                "summary": obj.get("summary"),
                "encrypted_content": obj.get("encrypted_content"),
            }
        )

        return _obj


class StreamingOpenAIReasoningModel:
    def __init__(
        self,  # optional properties
        summary: Optional[str] = None,
        encrypted_content: Optional[str] = None,
    ):
        """A model object representing the StreamingOpenAIReasoning resource.

                Constructs an object of type StreamingOpenAIReasoning with the provided properties.

                Parameters
                __________
                summary : str, optional
                    Reasoning summary tokens generated during the model response.

                encrypted_content : str, optional
                    The encrypted_content field is an opaque field and should not be interpreted or parsed.
        It should only be used for verifying that the reasoning blocks were generated by that specific model.
        """
        self.summary = summary
        self.encrypted_content = encrypted_content

    __properties = ["summary", "encrypted_content"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamingOpenAIReasoning(
            summary=self.summary,
            encrypted_content=self.encrypted_content,
        )

    @classmethod
    def _from_model(cls, model) -> StreamingOpenAIReasoningModel:
        return StreamingOpenAIReasoningModel(
            summary=model.summary,
            encrypted_content=model.encrypted_content,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StreamingOpenAIReasoning.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamingOpenAIReasoning object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingOpenAIReasoningModel:
        """Create an instance of StreamingOpenAIReasoning from a dict.

        This method constructs a StreamingOpenAIReasoning object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamingOpenAIReasoning
            A StreamingOpenAIReasoning object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamingOpenAIReasoning.from_dict(obj))


StreamingOpenAIReasoning._model_class = StreamingOpenAIReasoningModel
