"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr, field_validator

from snowflake.core.cortex.inference_service._generated.models.cache_control import CacheControl, CacheControlModel
from snowflake.core.cortex.inference_service._generated.models.tool_results_tool_results import (
    ToolResultsToolResults,
    ToolResultsToolResultsModel,
)


class ToolResults(BaseModel):
    """A model object representing the ToolResults resource.

    Constructs an object of type ToolResults with the provided properties.

    Parameters
    __________
    type : str
        Identifies this as tool results content
    tool_results : ToolResultsToolResults

    cache_control : CacheControl, optional
    """

    type: StrictStr

    tool_results: ToolResultsToolResults

    cache_control: Optional[CacheControl] = None

    __properties = ["type", "tool_results", "cache_control"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v not in ("tool_results"):
            raise ValueError("must validate the enum values ('tool_results')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ToolResults:
        """Create an instance of ToolResults from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of tool_results
        if self.tool_results:
            _dict["tool_results"] = self.tool_results.to_dict()

        # override the default output from pydantic by calling `to_dict()` of cache_control
        if self.cache_control:
            _dict["cache_control"] = self.cache_control.to_dict()

        # set to None if cache_control (nullable) is None
        if self.cache_control is None:
            _dict["cache_control"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ToolResults:
        """Create an instance of ToolResults from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ToolResults.parse_obj(obj)

        _obj = ToolResults.parse_obj(
            {
                "type": obj.get("type"),
                "tool_results": ToolResultsToolResults.from_dict(obj.get("tool_results"))
                if obj.get("tool_results") is not None
                else None,
                "cache_control": CacheControl.from_dict(obj.get("cache_control"))
                if obj.get("cache_control") is not None
                else None,
            }
        )

        return _obj


class ToolResultsModel:
    def __init__(
        self,
        type: str,
        tool_results: ToolResultsToolResults,
        # optional properties
        cache_control: Optional[CacheControl] = None,
    ):
        """A model object representing the ToolResults resource.

        Constructs an object of type ToolResults with the provided properties.

        Parameters
        __________
        type : str
            Identifies this as tool results content
        tool_results : ToolResultsToolResults

        cache_control : CacheControl, optional
        """
        self.type = type
        self.tool_results = tool_results
        self.cache_control = cache_control

    __properties = ["type", "tool_results", "cache_control"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ToolResults(
            type=self.type,
            tool_results=self.tool_results._to_model() if self.tool_results is not None else None,
            cache_control=self.cache_control._to_model() if self.cache_control is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> ToolResultsModel:
        return ToolResultsModel(
            type=model.type,
            tool_results=ToolResultsToolResultsModel._from_model(model.tool_results) if model.tool_results else None,
            cache_control=CacheControlModel._from_model(model.cache_control) if model.cache_control else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ToolResults.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ToolResults object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ToolResultsModel:
        """Create an instance of ToolResults from a dict.

        This method constructs a ToolResults object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ToolResults
            A ToolResults object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ToolResults.from_dict(obj))


ToolResults._model_class = ToolResultsModel
