"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, List, Optional

from pydantic import BaseModel, StrictStr


class ToolResultsToolResults(BaseModel):
    """A model object representing the ToolResultsToolResults resource.

    Constructs an object of type ToolResultsToolResults with the provided properties.

    Parameters
    __________
    tool_use_id : str
        Unique identifier linking this result to its corresponding tool use request
    name : str
        Name of the tool that was executed. Must match a tool name from the tools array
    content : list[object]
        Array of content elements produced by the tool execution
    status : str, optional
        status indicators for the tool execution
    result : object, optional
        Additional result data in an arbitrary structure
    """

    tool_use_id: StrictStr

    name: StrictStr

    content: List[Any]

    status: Optional[StrictStr] = None

    result: Optional[Dict[str, Any]] = None

    __properties = ["tool_use_id", "name", "content", "status", "result"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ToolResultsToolResults:
        """Create an instance of ToolResultsToolResults from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ToolResultsToolResults:
        """Create an instance of ToolResultsToolResults from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ToolResultsToolResults.parse_obj(obj)

        _obj = ToolResultsToolResults.parse_obj(
            {
                "tool_use_id": obj.get("tool_use_id"),
                "name": obj.get("name"),
                "content": obj.get("content"),
                "status": obj.get("status"),
                "result": obj.get("result"),
            }
        )

        return _obj


class ToolResultsToolResultsModel:
    def __init__(
        self,
        tool_use_id: str,
        name: str,
        content: list[object],
        # optional properties
        status: Optional[str] = None,
        result: Optional[object] = None,
    ):
        """A model object representing the ToolResultsToolResults resource.

        Constructs an object of type ToolResultsToolResults with the provided properties.

        Parameters
        __________
        tool_use_id : str
            Unique identifier linking this result to its corresponding tool use request
        name : str
            Name of the tool that was executed. Must match a tool name from the tools array
        content : list[object]
            Array of content elements produced by the tool execution
        status : str, optional
            status indicators for the tool execution
        result : object, optional
            Additional result data in an arbitrary structure
        """
        self.tool_use_id = tool_use_id
        self.name = name
        self.content = content
        self.status = status
        self.result = result

    __properties = ["tool_use_id", "name", "content", "status", "result"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ToolResultsToolResults(
            tool_use_id=self.tool_use_id,
            name=self.name,
            content=self.content,
            status=self.status,
            result=self.result,
        )

    @classmethod
    def _from_model(cls, model) -> ToolResultsToolResultsModel:
        return ToolResultsToolResultsModel(
            tool_use_id=model.tool_use_id,
            name=model.name,
            content=model.content,
            status=model.status,
            result=model.result,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ToolResultsToolResults.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ToolResultsToolResults object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ToolResultsToolResultsModel:
        """Create an instance of ToolResultsToolResults from a dict.

        This method constructs a ToolResultsToolResults object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ToolResultsToolResults
            A ToolResultsToolResults object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ToolResultsToolResults.from_dict(obj))


ToolResultsToolResults._model_class = ToolResultsToolResultsModel
