"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict

from pydantic import BaseModel, StrictStr


class ToolUseToolUse(BaseModel):
    """A model object representing the ToolUseToolUse resource.

    Constructs an object of type ToolUseToolUse with the provided properties.

    Parameters
    __________
    tool_use_id : str
        Unique identifier for this tool use request
    name : str
        Name of the tool to execute. Must match a tool name from the tools array
    input : object
        Input parameters for the tool execution
    """

    tool_use_id: StrictStr

    name: StrictStr

    input: Dict[str, Any]

    __properties = ["tool_use_id", "name", "input"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ToolUseToolUse:
        """Create an instance of ToolUseToolUse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ToolUseToolUse:
        """Create an instance of ToolUseToolUse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ToolUseToolUse.parse_obj(obj)

        _obj = ToolUseToolUse.parse_obj(
            {
                "tool_use_id": obj.get("tool_use_id"),
                "name": obj.get("name"),
                "input": obj.get("input"),
            }
        )

        return _obj


class ToolUseToolUseModel:
    def __init__(
        self,
        tool_use_id: str,
        name: str,
        input: object,
        # optional properties
    ):
        """A model object representing the ToolUseToolUse resource.

        Constructs an object of type ToolUseToolUse with the provided properties.

        Parameters
        __________
        tool_use_id : str
            Unique identifier for this tool use request
        name : str
            Name of the tool to execute. Must match a tool name from the tools array
        input : object
            Input parameters for the tool execution
        """
        self.tool_use_id = tool_use_id
        self.name = name
        self.input = input

    __properties = ["tool_use_id", "name", "input"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ToolUseToolUse(
            tool_use_id=self.tool_use_id,
            name=self.name,
            input=self.input,
        )

    @classmethod
    def _from_model(cls, model) -> ToolUseToolUseModel:
        return ToolUseToolUseModel(
            tool_use_id=model.tool_use_id,
            name=model.name,
            input=model.input,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ToolUseToolUse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ToolUseToolUse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ToolUseToolUseModel:
        """Create an instance of ToolUseToolUse from a dict.

        This method constructs a ToolUseToolUse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ToolUseToolUse
            A ToolUseToolUse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ToolUseToolUse.from_dict(obj))


ToolUseToolUse._model_class = ToolUseToolUseModel
