"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, Field, StrictInt
from typing_extensions import Annotated


class Usage(BaseModel):
    """A model object representing the Usage resource.

    Constructs an object of type Usage with the provided properties.

    Parameters
    __________
    prompt_tokens : int, optional
        Input token count.
    completion_tokens : int, optional
        Output token count.
    guard_tokens : int, optional
        Tokens used by cortex guard.
    total_tokens : int, optional
        Sum of all tokens.
    cache_read_input_tokens : int, optional
        reserved
    cache_write_input_tokens : int, optional
        reserved
    """

    prompt_tokens: Optional[StrictInt] = None

    completion_tokens: Optional[StrictInt] = None

    guard_tokens: Optional[StrictInt] = None

    total_tokens: Optional[StrictInt] = None

    cache_read_input_tokens: Optional[Annotated[int, Field(strict=True, ge=0)]] = None

    cache_write_input_tokens: Optional[Annotated[int, Field(strict=True, ge=0)]] = None

    __properties = [
        "prompt_tokens",
        "completion_tokens",
        "guard_tokens",
        "total_tokens",
        "cache_read_input_tokens",
        "cache_write_input_tokens",
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Usage:
        """Create an instance of Usage from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # set to None if cache_read_input_tokens (nullable) is None
        if self.cache_read_input_tokens is None:
            _dict["cache_read_input_tokens"] = None

        # set to None if cache_write_input_tokens (nullable) is None
        if self.cache_write_input_tokens is None:
            _dict["cache_write_input_tokens"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Usage:
        """Create an instance of Usage from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Usage.parse_obj(obj)

        _obj = Usage.parse_obj(
            {
                "prompt_tokens": obj.get("prompt_tokens"),
                "completion_tokens": obj.get("completion_tokens"),
                "guard_tokens": obj.get("guard_tokens"),
                "total_tokens": obj.get("total_tokens"),
                "cache_read_input_tokens": obj.get("cache_read_input_tokens"),
                "cache_write_input_tokens": obj.get("cache_write_input_tokens"),
            }
        )

        return _obj


class UsageModel:
    def __init__(
        self,  # optional properties
        prompt_tokens: Optional[int] = None,
        completion_tokens: Optional[int] = None,
        guard_tokens: Optional[int] = None,
        total_tokens: Optional[int] = None,
        cache_read_input_tokens: Optional[int] = None,
        cache_write_input_tokens: Optional[int] = None,
    ):
        """A model object representing the Usage resource.

        Constructs an object of type Usage with the provided properties.

        Parameters
        __________
        prompt_tokens : int, optional
            Input token count.
        completion_tokens : int, optional
            Output token count.
        guard_tokens : int, optional
            Tokens used by cortex guard.
        total_tokens : int, optional
            Sum of all tokens.
        cache_read_input_tokens : int, optional
            reserved
        cache_write_input_tokens : int, optional
            reserved
        """
        self.prompt_tokens = prompt_tokens
        self.completion_tokens = completion_tokens
        self.guard_tokens = guard_tokens
        self.total_tokens = total_tokens
        self.cache_read_input_tokens = cache_read_input_tokens
        self.cache_write_input_tokens = cache_write_input_tokens

    __properties = [
        "prompt_tokens",
        "completion_tokens",
        "guard_tokens",
        "total_tokens",
        "cache_read_input_tokens",
        "cache_write_input_tokens",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Usage(
            prompt_tokens=self.prompt_tokens,
            completion_tokens=self.completion_tokens,
            guard_tokens=self.guard_tokens,
            total_tokens=self.total_tokens,
            cache_read_input_tokens=self.cache_read_input_tokens,
            cache_write_input_tokens=self.cache_write_input_tokens,
        )

    @classmethod
    def _from_model(cls, model) -> UsageModel:
        return UsageModel(
            prompt_tokens=model.prompt_tokens,
            completion_tokens=model.completion_tokens,
            guard_tokens=model.guard_tokens,
            total_tokens=model.total_tokens,
            cache_read_input_tokens=model.cache_read_input_tokens,
            cache_write_input_tokens=model.cache_write_input_tokens,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Usage.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Usage object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> UsageModel:
        """Create an instance of Usage from a dict.

        This method constructs a Usage object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Usage
            A Usage object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Usage.from_dict(obj))


Usage._model_class = UsageModel
