"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class AgentModels(BaseModel):
    """A model object representing the AgentModels resource.

    Constructs an object of type AgentModels with the provided properties.

    Parameters
    __________
    orchestration : str, optional
        Model to use for orchestration. If not provided, a model is automatically selected.
    """

    orchestration: Optional[StrictStr] = None

    __properties = ["orchestration"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AgentModels:
        """Create an instance of AgentModels from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AgentModels:
        """Create an instance of AgentModels from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AgentModels.parse_obj(obj)

        _obj = AgentModels.parse_obj(
            {
                "orchestration": obj.get("orchestration"),
            }
        )

        return _obj


class AgentModelsModel:
    def __init__(
        self,  # optional properties
        orchestration: Optional[str] = None,
    ):
        """A model object representing the AgentModels resource.

        Constructs an object of type AgentModels with the provided properties.

        Parameters
        __________
        orchestration : str, optional
            Model to use for orchestration. If not provided, a model is automatically selected.
        """
        self.orchestration = orchestration

    __properties = ["orchestration"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AgentModels(
            orchestration=self.orchestration,
        )

    @classmethod
    def _from_model(cls, model) -> AgentModelsModel:
        return AgentModelsModel(
            orchestration=model.orchestration,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AgentModels.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AgentModels object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AgentModelsModel:
        """Create an instance of AgentModels from a dict.

        This method constructs a AgentModels object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AgentModels
            A AgentModels object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AgentModels.from_dict(obj))


AgentModels._model_class = AgentModelsModel
