"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing_extensions import Annotated

from snowflake.core.cortex.lite_agent_service._generated.models.agent_instructions import (
    AgentInstructions,
    AgentInstructionsModel,
)
from snowflake.core.cortex.lite_agent_service._generated.models.agent_models import AgentModels, AgentModelsModel
from snowflake.core.cortex.lite_agent_service._generated.models.agent_orchestration import (
    AgentOrchestration,
    AgentOrchestrationModel,
)
from snowflake.core.cortex.lite_agent_service._generated.models.message import Message, MessageModel
from snowflake.core.cortex.lite_agent_service._generated.models.tool import Tool, ToolModel
from snowflake.core.cortex.lite_agent_service._generated.models.tool_choice import ToolChoice, ToolChoiceModel


class AgentRunRequest(BaseModel):
    """A model object representing the AgentRunRequest resource.

    Constructs an object of type AgentRunRequest with the provided properties.

    Parameters
    __________
    messages : list[Message]
        The conversation history and current message.
        Contains both user queries and assistant responses in chronological order.
    models : AgentModels, optional

    orchestration : AgentOrchestration, optional

    instructions : AgentInstructions, optional

    model : str, optional
        The identifier of the LLM to use for processing.
    response_instruction : str, optional
        Optional instructions to guide the model's response style and behavior.
        Can be used to set the tone, format, or specific requirements for responses.
    experimental : object, optional
        reserved
    tools : list[Tool], optional
        List of tools available for the agent to use.
        Tools may have a corresponding configuration in tool_resources.
    tool_resources : Dict[str, object], optional
        Configuration for each tool referenced in the tools array.
        Keys must match the name field of tools.
    tool_choice : ToolChoice, optional

    thread_id : int, optional
        The id of the thread.
    parent_message_id : int, optional
        The id of the message from which this run should begin.
    """

    models: Optional[AgentModels] = None

    orchestration: Optional[AgentOrchestration] = None

    instructions: Optional[AgentInstructions] = None

    model: Optional[StrictStr] = None

    response_instruction: Optional[StrictStr] = None

    experimental: Optional[Dict[str, Any]] = None

    messages: Annotated[List[Message], Field(min_length=1)]

    tools: Optional[List[Tool]] = None

    tool_resources: Optional[Dict[str, Dict[str, Any]]] = None

    tool_choice: Optional[ToolChoice] = None

    thread_id: Optional[StrictInt] = None

    parent_message_id: Optional[StrictInt] = None

    __properties = [
        "models",
        "orchestration",
        "instructions",
        "model",
        "response_instruction",
        "experimental",
        "messages",
        "tools",
        "tool_resources",
        "tool_choice",
        "thread_id",
        "parent_message_id",
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AgentRunRequest:
        """Create an instance of AgentRunRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of models
        if self.models:
            _dict["models"] = self.models.to_dict()

        # override the default output from pydantic by calling `to_dict()` of orchestration
        if self.orchestration:
            _dict["orchestration"] = self.orchestration.to_dict()

        # override the default output from pydantic by calling `to_dict()` of instructions
        if self.instructions:
            _dict["instructions"] = self.instructions.to_dict()

        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict["messages"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in tools (list)
        _items = []
        if self.tools:
            for _item in self.tools:
                if _item:
                    _items.append(_item.to_dict())
            _dict["tools"] = _items

        # override the default output from pydantic by calling `to_dict()` of tool_choice
        if self.tool_choice:
            _dict["tool_choice"] = self.tool_choice.to_dict()

        # set to None if tool_choice (nullable) is None
        if self.tool_choice is None:
            _dict["tool_choice"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AgentRunRequest:
        """Create an instance of AgentRunRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AgentRunRequest.parse_obj(obj)

        _obj = AgentRunRequest.parse_obj(
            {
                "models": AgentModels.from_dict(obj.get("models")) if obj.get("models") is not None else None,
                "orchestration": AgentOrchestration.from_dict(obj.get("orchestration"))
                if obj.get("orchestration") is not None
                else None,
                "instructions": AgentInstructions.from_dict(obj.get("instructions"))
                if obj.get("instructions") is not None
                else None,
                "model": obj.get("model"),
                "response_instruction": obj.get("response_instruction"),
                "experimental": obj.get("experimental"),
                "messages": [Message.from_dict(_item) for _item in obj.get("messages")]
                if obj.get("messages") is not None
                else None,
                "tools": [Tool.from_dict(_item) for _item in obj.get("tools")]
                if obj.get("tools") is not None
                else None,
                "tool_resources": obj.get("tool_resources"),
                "tool_choice": ToolChoice.from_dict(obj.get("tool_choice"))
                if obj.get("tool_choice") is not None
                else None,
                "thread_id": obj.get("thread_id"),
                "parent_message_id": obj.get("parent_message_id"),
            }
        )

        return _obj


class AgentRunRequestModel:
    def __init__(
        self,
        messages: list[Message],
        # optional properties
        models: Optional[AgentModels] = None,
        orchestration: Optional[AgentOrchestration] = None,
        instructions: Optional[AgentInstructions] = None,
        model: Optional[str] = None,
        response_instruction: Optional[str] = None,
        experimental: Optional[object] = None,
        tools: Optional[list[Tool]] = None,
        tool_resources: Optional[Dict[str, object]] = None,
        tool_choice: Optional[ToolChoice] = None,
        thread_id: Optional[int] = None,
        parent_message_id: Optional[int] = None,
    ):
        """A model object representing the AgentRunRequest resource.

                Constructs an object of type AgentRunRequest with the provided properties.

                Parameters
                __________
                messages : list[Message]
                    The conversation history and current message.
        Contains both user queries and assistant responses in chronological order.

                models : AgentModels, optional

                orchestration : AgentOrchestration, optional

                instructions : AgentInstructions, optional

                model : str, optional
                    The identifier of the LLM to use for processing.
                response_instruction : str, optional
                    Optional instructions to guide the model's response style and behavior.
        Can be used to set the tone, format, or specific requirements for responses.

                experimental : object, optional
                    reserved
                tools : list[Tool], optional
                    List of tools available for the agent to use.
        Tools may have a corresponding configuration in tool_resources.

                tool_resources : Dict[str, object], optional
                    Configuration for each tool referenced in the tools array.
        Keys must match the name field of tools.

                tool_choice : ToolChoice, optional

                thread_id : int, optional
                    The id of the thread.

                parent_message_id : int, optional
                    The id of the message from which this run should begin.
        """
        self.models = models
        self.orchestration = orchestration
        self.instructions = instructions
        self.model = model
        self.response_instruction = response_instruction
        self.experimental = experimental
        self.messages = messages
        self.tools = tools
        self.tool_resources = tool_resources
        self.tool_choice = tool_choice
        self.thread_id = thread_id
        self.parent_message_id = parent_message_id

    __properties = [
        "models",
        "orchestration",
        "instructions",
        "model",
        "response_instruction",
        "experimental",
        "messages",
        "tools",
        "tool_resources",
        "tool_choice",
        "thread_id",
        "parent_message_id",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AgentRunRequest(
            models=self.models._to_model() if self.models is not None else None,
            orchestration=self.orchestration._to_model() if self.orchestration is not None else None,
            instructions=self.instructions._to_model() if self.instructions is not None else None,
            model=self.model,
            response_instruction=self.response_instruction,
            experimental=self.experimental,
            messages=[x._to_model() for x in self.messages] if self.messages is not None else None,
            tools=[x._to_model() for x in self.tools] if self.tools is not None else None,
            tool_resources=self.tool_resources,
            tool_choice=self.tool_choice._to_model() if self.tool_choice is not None else None,
            thread_id=self.thread_id,
            parent_message_id=self.parent_message_id,
        )

    @classmethod
    def _from_model(cls, model) -> AgentRunRequestModel:
        return AgentRunRequestModel(
            models=AgentModelsModel._from_model(model.models) if model.models else None,
            orchestration=AgentOrchestrationModel._from_model(model.orchestration) if model.orchestration else None,
            instructions=AgentInstructionsModel._from_model(model.instructions) if model.instructions else None,
            model=model.model,
            response_instruction=model.response_instruction,
            experimental=model.experimental,
            messages=[MessageModel._from_model(x) for x in model.messages] if model.messages else None,
            tools=[ToolModel._from_model(x) for x in model.tools] if model.tools else None,
            tool_resources=model.tool_resources,
            tool_choice=ToolChoiceModel._from_model(model.tool_choice) if model.tool_choice else None,
            thread_id=model.thread_id,
            parent_message_id=model.parent_message_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AgentRunRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AgentRunRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AgentRunRequestModel:
        """Create an instance of AgentRunRequest from a dict.

        This method constructs a AgentRunRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AgentRunRequest
            A AgentRunRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AgentRunRequest.from_dict(obj))


AgentRunRequest._model_class = AgentRunRequestModel
