"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class SampleQuestion(BaseModel):
    """A model object representing the SampleQuestion resource.

    Constructs an object of type SampleQuestion with the provided properties.

    Parameters
    __________
    question : str, optional
        Sample question.
    answer : str, optional
        Optional sample answer.
    """

    question: Optional[StrictStr] = None

    answer: Optional[StrictStr] = None

    __properties = ["question", "answer"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SampleQuestion:
        """Create an instance of SampleQuestion from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SampleQuestion:
        """Create an instance of SampleQuestion from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SampleQuestion.parse_obj(obj)

        _obj = SampleQuestion.parse_obj(
            {
                "question": obj.get("question"),
                "answer": obj.get("answer"),
            }
        )

        return _obj


class SampleQuestionModel:
    def __init__(
        self,  # optional properties
        question: Optional[str] = None,
        answer: Optional[str] = None,
    ):
        """A model object representing the SampleQuestion resource.

        Constructs an object of type SampleQuestion with the provided properties.

        Parameters
        __________
        question : str, optional
            Sample question.

        answer : str, optional
            Optional sample answer.
        """
        self.question = question
        self.answer = answer

    __properties = ["question", "answer"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SampleQuestion(
            question=self.question,
            answer=self.answer,
        )

    @classmethod
    def _from_model(cls, model) -> SampleQuestionModel:
        return SampleQuestionModel(
            question=model.question,
            answer=model.answer,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SampleQuestion.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SampleQuestion object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SampleQuestionModel:
        """Create an instance of SampleQuestion from a dict.

        This method constructs a SampleQuestion object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SampleQuestion
            A SampleQuestion object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SampleQuestion.from_dict(obj))


SampleQuestion._model_class = SampleQuestionModel
