"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel

from snowflake.core.cortex.search_service._generated.models.numeric_boost import NumericBoost, NumericBoostModel
from snowflake.core.cortex.search_service._generated.models.query_similarity_boost import (
    QuerySimilarityBoost,
    QuerySimilarityBoostModel,
)
from snowflake.core.cortex.search_service._generated.models.text_boost import TextBoost, TextBoostModel
from snowflake.core.cortex.search_service._generated.models.time_decay import TimeDecay, TimeDecayModel
from snowflake.core.cortex.search_service._generated.models.vector_boost import VectorBoost, VectorBoostModel


class Functions(BaseModel):
    """A model object representing the Functions resource.

    Constructs an object of type Functions with the provided properties.

    Parameters
    __________
    numeric_boosts : list[NumericBoost], optional

    time_decays : list[TimeDecay], optional

    text_boosts : list[TextBoost], optional

    vector_boosts : list[VectorBoost], optional

    query_similarity_boosts : list[QuerySimilarityBoost], optional
    """

    numeric_boosts: Optional[List[NumericBoost]] = None

    time_decays: Optional[List[TimeDecay]] = None

    text_boosts: Optional[List[TextBoost]] = None

    vector_boosts: Optional[List[VectorBoost]] = None

    query_similarity_boosts: Optional[List[QuerySimilarityBoost]] = None

    __properties = ["numeric_boosts", "time_decays", "text_boosts", "vector_boosts", "query_similarity_boosts"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Functions:
        """Create an instance of Functions from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in numeric_boosts (list)
        _items = []
        if self.numeric_boosts:
            for _item in self.numeric_boosts:
                if _item:
                    _items.append(_item.to_dict())
            _dict["numeric_boosts"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in time_decays (list)
        _items = []
        if self.time_decays:
            for _item in self.time_decays:
                if _item:
                    _items.append(_item.to_dict())
            _dict["time_decays"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in text_boosts (list)
        _items = []
        if self.text_boosts:
            for _item in self.text_boosts:
                if _item:
                    _items.append(_item.to_dict())
            _dict["text_boosts"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in vector_boosts (list)
        _items = []
        if self.vector_boosts:
            for _item in self.vector_boosts:
                if _item:
                    _items.append(_item.to_dict())
            _dict["vector_boosts"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in query_similarity_boosts (list)
        _items = []
        if self.query_similarity_boosts:
            for _item in self.query_similarity_boosts:
                if _item:
                    _items.append(_item.to_dict())
            _dict["query_similarity_boosts"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Functions:
        """Create an instance of Functions from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Functions.parse_obj(obj)

        _obj = Functions.parse_obj(
            {
                "numeric_boosts": [NumericBoost.from_dict(_item) for _item in obj.get("numeric_boosts")]
                if obj.get("numeric_boosts") is not None
                else None,
                "time_decays": [TimeDecay.from_dict(_item) for _item in obj.get("time_decays")]
                if obj.get("time_decays") is not None
                else None,
                "text_boosts": [TextBoost.from_dict(_item) for _item in obj.get("text_boosts")]
                if obj.get("text_boosts") is not None
                else None,
                "vector_boosts": [VectorBoost.from_dict(_item) for _item in obj.get("vector_boosts")]
                if obj.get("vector_boosts") is not None
                else None,
                "query_similarity_boosts": [
                    QuerySimilarityBoost.from_dict(_item) for _item in obj.get("query_similarity_boosts")
                ]
                if obj.get("query_similarity_boosts") is not None
                else None,
            }
        )

        return _obj


class FunctionsModel:
    def __init__(
        self,  # optional properties
        numeric_boosts: Optional[list[NumericBoost]] = None,
        time_decays: Optional[list[TimeDecay]] = None,
        text_boosts: Optional[list[TextBoost]] = None,
        vector_boosts: Optional[list[VectorBoost]] = None,
        query_similarity_boosts: Optional[list[QuerySimilarityBoost]] = None,
    ):
        """A model object representing the Functions resource.

        Constructs an object of type Functions with the provided properties.

        Parameters
        __________
        numeric_boosts : list[NumericBoost], optional

        time_decays : list[TimeDecay], optional

        text_boosts : list[TextBoost], optional

        vector_boosts : list[VectorBoost], optional

        query_similarity_boosts : list[QuerySimilarityBoost], optional
        """
        self.numeric_boosts = numeric_boosts
        self.time_decays = time_decays
        self.text_boosts = text_boosts
        self.vector_boosts = vector_boosts
        self.query_similarity_boosts = query_similarity_boosts

    __properties = ["numeric_boosts", "time_decays", "text_boosts", "vector_boosts", "query_similarity_boosts"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Functions(
            numeric_boosts=[x._to_model() for x in self.numeric_boosts] if self.numeric_boosts is not None else None,
            time_decays=[x._to_model() for x in self.time_decays] if self.time_decays is not None else None,
            text_boosts=[x._to_model() for x in self.text_boosts] if self.text_boosts is not None else None,
            vector_boosts=[x._to_model() for x in self.vector_boosts] if self.vector_boosts is not None else None,
            query_similarity_boosts=[x._to_model() for x in self.query_similarity_boosts]
            if self.query_similarity_boosts is not None
            else None,
        )

    @classmethod
    def _from_model(cls, model) -> FunctionsModel:
        return FunctionsModel(
            numeric_boosts=[NumericBoostModel._from_model(x) for x in model.numeric_boosts]
            if model.numeric_boosts
            else None,
            time_decays=[TimeDecayModel._from_model(x) for x in model.time_decays] if model.time_decays else None,
            text_boosts=[TextBoostModel._from_model(x) for x in model.text_boosts] if model.text_boosts else None,
            vector_boosts=[VectorBoostModel._from_model(x) for x in model.vector_boosts]
            if model.vector_boosts
            else None,
            query_similarity_boosts=[QuerySimilarityBoostModel._from_model(x) for x in model.query_similarity_boosts]
            if model.query_similarity_boosts
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Functions.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Functions object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> FunctionsModel:
        """Create an instance of Functions from a dict.

        This method constructs a Functions object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Functions
            A Functions object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Functions.from_dict(obj))


Functions._model_class = FunctionsModel
