"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictInt, StrictStr


class SuggestQueryRequest(BaseModel):
    """A model object representing the SuggestQueryRequest resource.

    Constructs an object of type SuggestQueryRequest with the provided properties.

    Parameters
    __________
    query : str
        The text query on which to suggest.
    columns : list[str], optional
        List of columns to return.
    limit : int,  default 5
        Max number of results to return.
    """

    query: StrictStr

    columns: Optional[List[StrictStr]] = None

    limit: Optional[StrictInt] = 5

    __properties = ["query", "columns", "limit"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SuggestQueryRequest:
        """Create an instance of SuggestQueryRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SuggestQueryRequest:
        """Create an instance of SuggestQueryRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SuggestQueryRequest.parse_obj(obj)

        _obj = SuggestQueryRequest.parse_obj(
            {
                "query": obj.get("query"),
                "columns": obj.get("columns"),
                "limit": obj.get("limit") if obj.get("limit") is not None else 5,
            }
        )

        return _obj


class SuggestQueryRequestModel:
    def __init__(
        self,
        query: str,
        # optional properties
        columns: Optional[list[str]] = None,
        limit: Optional[int] = 5,
    ):
        """A model object representing the SuggestQueryRequest resource.

        Constructs an object of type SuggestQueryRequest with the provided properties.

        Parameters
        __________
        query : str
            The text query on which to suggest.
        columns : list[str], optional
            List of columns to return.
        limit : int,  default 5
            Max number of results to return.
        """
        self.query = query
        self.columns = columns
        self.limit = limit

    __properties = ["query", "columns", "limit"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SuggestQueryRequest(
            query=self.query,
            columns=self.columns,
            limit=self.limit,
        )

    @classmethod
    def _from_model(cls, model) -> SuggestQueryRequestModel:
        return SuggestQueryRequestModel(
            query=model.query,
            columns=model.columns,
            limit=model.limit,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SuggestQueryRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SuggestQueryRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SuggestQueryRequestModel:
        """Create an instance of SuggestQueryRequest from a dict.

        This method constructs a SuggestQueryRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SuggestQueryRequest
            A SuggestQueryRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SuggestQueryRequest.from_dict(obj))


SuggestQueryRequest._model_class = SuggestQueryRequestModel
