"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import StrictInt

from snowflake.core.cortex.search_service._generated.models.target_lag import TargetLag


class UserDefinedLag(TargetLag):
    """A model object representing the UserDefinedLag resource.

    Constructs an object of type UserDefinedLag with the provided properties.

    Parameters
    __________
    seconds : int
        Target lag time in seconds.
    """

    seconds: StrictInt

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserDefinedLag:
        """Create an instance of UserDefinedLag from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["type"] = TargetLag.get_child_model_discriminator_value("UserDefinedLag")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> UserDefinedLag:
        """Create an instance of UserDefinedLag from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UserDefinedLag.parse_obj(obj)

        _obj = UserDefinedLag.parse_obj(
            {
                "seconds": obj.get("seconds"),
            }
        )

        return _obj


class UserDefinedLagModel(TargetLag):
    def __init__(
        self,
        seconds: int,
        # optional properties
    ):
        """A model object representing the UserDefinedLag resource.

        Constructs an object of type UserDefinedLag with the provided properties.

        Parameters
        __________
        seconds : int
            Target lag time in seconds.
        """
        super().__init__()
        self.seconds = seconds

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return UserDefinedLag(
            seconds=self.seconds,
        )

    @classmethod
    def _from_model(cls, model) -> UserDefinedLagModel:
        return UserDefinedLagModel(
            seconds=model.seconds,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a UserDefinedLag.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the UserDefinedLag object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> UserDefinedLagModel:
        """Create an instance of UserDefinedLag from a dict.

        This method constructs a UserDefinedLag object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        UserDefinedLag
            A UserDefinedLag object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(UserDefinedLag.from_dict(obj))


UserDefinedLag._model_class = UserDefinedLagModel
