"""
Snowflake Database API.

The Snowflake Database API is a REST API that you can use to access, update, and perform certain actions on Database resource in Snowflake.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List

from pydantic import BaseModel, Field
from typing_extensions import Annotated


class AccountIdentifiers(BaseModel):
    """A model object representing the AccountIdentifiers resource.

    Constructs an object of type AccountIdentifiers with the provided properties.

    Parameters
    __________
    accounts : list[str]
    """

    accounts: List[Annotated[str, Field(min_length=1, strict=True)]]

    __properties = ["accounts"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountIdentifiers:
        """Create an instance of AccountIdentifiers from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AccountIdentifiers:
        """Create an instance of AccountIdentifiers from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountIdentifiers.parse_obj(obj)

        _obj = AccountIdentifiers.parse_obj(
            {
                "accounts": obj.get("accounts"),
            }
        )

        return _obj


class AccountIdentifiersModel:
    def __init__(
        self,
        accounts: list[str],
        # optional properties
    ):
        """A model object representing the AccountIdentifiers resource.

        Constructs an object of type AccountIdentifiers with the provided properties.

        Parameters
        __________
        accounts : list[str]
        """
        self.accounts = accounts

    __properties = ["accounts"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AccountIdentifiers(
            accounts=self.accounts,
        )

    @classmethod
    def _from_model(cls, model) -> AccountIdentifiersModel:
        return AccountIdentifiersModel(
            accounts=model.accounts,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AccountIdentifiers.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AccountIdentifiers object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AccountIdentifiersModel:
        """Create an instance of AccountIdentifiers from a dict.

        This method constructs a AccountIdentifiers object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AccountIdentifiers
            A AccountIdentifiers object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AccountIdentifiers.from_dict(obj))


AccountIdentifiers._model_class = AccountIdentifiersModel
