"""
Snowflake Database API.

The Snowflake Database API is a REST API that you can use to access, update, and perform certain actions on Database resource in Snowflake.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class SuccessResponse(BaseModel):
    """A model object representing the SuccessResponse resource.

    Constructs an object of type SuccessResponse with the provided properties.

    Parameters
    __________
    status : str, optional
        Message returned by the server.
    """

    status: Optional[StrictStr] = None

    __properties = ["status"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SuccessResponse:
        """Create an instance of SuccessResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SuccessResponse:
        """Create an instance of SuccessResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SuccessResponse.parse_obj(obj)

        _obj = SuccessResponse.parse_obj(
            {
                "status": obj.get("status"),
            }
        )

        return _obj


class SuccessResponseModel:
    def __init__(
        self,  # optional properties
        status: Optional[str] = None,
    ):
        """A model object representing the SuccessResponse resource.

        Constructs an object of type SuccessResponse with the provided properties.

        Parameters
        __________
        status : str, optional
            Message returned by the server.
        """
        self.status = status

    __properties = ["status"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SuccessResponse(
            status=self.status,
        )

    @classmethod
    def _from_model(cls, model) -> SuccessResponseModel:
        return SuccessResponseModel(
            status=model.status,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SuccessResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SuccessResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SuccessResponseModel:
        """Create an instance of SuccessResponse from a dict.

        This method constructs a SuccessResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SuccessResponse
            A SuccessResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SuccessResponse.from_dict(obj))


SuccessResponse._model_class = SuccessResponseModel
