"""
Snowflake Dynamic Table API.

The Snowflake Dynamic Table API is a REST API that you can use to access, update, and perform certain actions on Dynamic Tables resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import StrictStr

from snowflake.core.dynamic_table._generated.models.point_of_time import PointOfTime


class PointOfTimeStatement(PointOfTime):
    """A model object representing the PointOfTimeStatement resource.

    Constructs an object of type PointOfTimeStatement with the provided properties.

    Parameters
    __________

    reference : str, optional
        Relation to the point of time. Currently, the API supports `at` and `before`.

    statement : str, optional
        Query ID of a statement to use as the reference point (e.g. 01bcf40d-0002-197f-0000-045701e2306e).
    """

    statement: Optional[StrictStr] = None

    __properties = ["point_of_time_type", "reference"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PointOfTimeStatement:
        """Create an instance of PointOfTimeStatement from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["point_of_time_type"] = PointOfTime.get_child_model_discriminator_value("PointOfTimeStatement")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PointOfTimeStatement:
        """Create an instance of PointOfTimeStatement from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PointOfTimeStatement.parse_obj(obj)

        _obj = PointOfTimeStatement.parse_obj(
            {
                "reference": obj.get("reference"),
                "statement": obj.get("statement"),
            }
        )

        return _obj


class PointOfTimeStatementModel(PointOfTime):
    def __init__(
        self,  # optional properties
        reference: Optional[str] = None,
        statement: Optional[str] = None,
    ):
        """A model object representing the PointOfTimeStatement resource.

        Constructs an object of type PointOfTimeStatement with the provided properties.

        Parameters
        __________

        reference : str, optional
            Relation to the point of time. Currently, the API supports `at` and `before`.

        statement : str, optional
            Query ID of a statement to use as the reference point (e.g. 01bcf40d-0002-197f-0000-045701e2306e).
        """
        super().__init__(
            reference=reference,
        )
        self.statement = statement

    __properties = ["point_of_time_type", "reference"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PointOfTimeStatement(
            reference=self.reference,
            statement=self.statement,
        )

    @classmethod
    def _from_model(cls, model) -> PointOfTimeStatementModel:
        return PointOfTimeStatementModel(
            reference=model.reference,
            statement=model.statement,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PointOfTimeStatement.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PointOfTimeStatement object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PointOfTimeStatementModel:
        """Create an instance of PointOfTimeStatement from a dict.

        This method constructs a PointOfTimeStatement object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PointOfTimeStatement
            A PointOfTimeStatement object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PointOfTimeStatement.from_dict(obj))


PointOfTimeStatement._model_class = PointOfTimeStatementModel
