"""
Snowflake External Volume API.

The Snowflake External Volume API is a REST API that you can use to access, update, and perform certain actions on External Volume resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr, field_validator


class Encryption(BaseModel):
    """A model object representing the Encryption resource.

    Constructs an object of type Encryption with the provided properties.

    Parameters
    __________
    type : str
        Specifies the encryption type used.
    kms_key_id : str, optional
        Specifies the ID for the Cloud KMS-managed key used to encrypt files written to the bucket.
    """

    type: StrictStr

    kms_key_id: Optional[StrictStr] = None

    __properties = ["type", "kms_key_id"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v not in ("NONE", "AWS_SSE_S3", "AWS_SSE_KMS", "GCS_SSE_KMS"):
            raise ValueError("must validate the enum values ('NONE','AWS_SSE_S3','AWS_SSE_KMS','GCS_SSE_KMS')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Encryption:
        """Create an instance of Encryption from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Encryption:
        """Create an instance of Encryption from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Encryption.parse_obj(obj)

        _obj = Encryption.parse_obj(
            {
                "type": obj.get("type"),
                "kms_key_id": obj.get("kms_key_id"),
            }
        )

        return _obj


class EncryptionModel:
    def __init__(
        self,
        type: str,
        # optional properties
        kms_key_id: Optional[str] = None,
    ):
        """A model object representing the Encryption resource.

        Constructs an object of type Encryption with the provided properties.

        Parameters
        __________
        type : str
            Specifies the encryption type used.
        kms_key_id : str, optional
            Specifies the ID for the Cloud KMS-managed key used to encrypt files written to the bucket.
        """
        self.type = type
        self.kms_key_id = kms_key_id

    __properties = ["type", "kms_key_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Encryption(
            type=self.type,
            kms_key_id=self.kms_key_id,
        )

    @classmethod
    def _from_model(cls, model) -> EncryptionModel:
        return EncryptionModel(
            type=model.type,
            kms_key_id=model.kms_key_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Encryption.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Encryption object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> EncryptionModel:
        """Create an instance of Encryption from a dict.

        This method constructs a Encryption object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Encryption
            A Encryption object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Encryption.from_dict(obj))


Encryption._model_class = EncryptionModel
