"""
Snowflake External Volume API.

The Snowflake External Volume API is a REST API that you can use to access, update, and perform certain actions on External Volume resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import StrictStr

from snowflake.core.external_volume._generated.models.storage_location import StorageLocation


class StorageLocationAzure(StorageLocation):
    """A model object representing the StorageLocationAzure resource.

    Constructs an object of type StorageLocationAzure with the provided properties.

    Parameters
    __________

    name : str

    azure_tenant_id : str
        Specifies the ID for your Office 365 tenant that the allowed and blocked storage accounts belong to.
    storage_base_url : str
        Specifies the base URL for your cloud storage location.
    """

    azure_tenant_id: StrictStr

    storage_base_url: StrictStr

    __properties = ["name", "storage_provider"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StorageLocationAzure:
        """Create an instance of StorageLocationAzure from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["storage_provider"] = StorageLocation.get_child_model_discriminator_value("StorageLocationAzure")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StorageLocationAzure:
        """Create an instance of StorageLocationAzure from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StorageLocationAzure.parse_obj(obj)

        _obj = StorageLocationAzure.parse_obj(
            {
                "name": obj.get("name"),
                "azure_tenant_id": obj.get("azure_tenant_id"),
                "storage_base_url": obj.get("storage_base_url"),
            }
        )

        return _obj


class StorageLocationAzureModel(StorageLocation):
    def __init__(
        self,
        name: str,
        azure_tenant_id: str,
        storage_base_url: str,
        # optional properties
    ):
        """A model object representing the StorageLocationAzure resource.

        Constructs an object of type StorageLocationAzure with the provided properties.

        Parameters
        __________

        name : str

        azure_tenant_id : str
            Specifies the ID for your Office 365 tenant that the allowed and blocked storage accounts belong to.
        storage_base_url : str
            Specifies the base URL for your cloud storage location.
        """
        super().__init__(
            name=name,
        )
        self.azure_tenant_id = azure_tenant_id
        self.storage_base_url = storage_base_url

    __properties = ["name", "storage_provider"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StorageLocationAzure(
            name=self.name,
            azure_tenant_id=self.azure_tenant_id,
            storage_base_url=self.storage_base_url,
        )

    @classmethod
    def _from_model(cls, model) -> StorageLocationAzureModel:
        return StorageLocationAzureModel(
            name=model.name,
            azure_tenant_id=model.azure_tenant_id,
            storage_base_url=model.storage_base_url,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StorageLocationAzure.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StorageLocationAzure object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StorageLocationAzureModel:
        """Create an instance of StorageLocationAzure from a dict.

        This method constructs a StorageLocationAzure object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StorageLocationAzure
            A StorageLocationAzure object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StorageLocationAzure.from_dict(obj))


StorageLocationAzure._model_class = StorageLocationAzureModel
