"""
Snowflake Iceberg Table API.

The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr, field_validator


class ConvertToManagedIcebergTableRequest(BaseModel):
    """A model object representing the ConvertToManagedIcebergTableRequest resource.

    Constructs an object of type ConvertToManagedIcebergTableRequest with the provided properties.

    Parameters
    __________
    base_location : str, optional
        The path to a directory where Snowflake can write data and metadata files for the table.
    storage_serialization_policy : str, optional
        Specifies the storage serialization policy for the table.
    """

    base_location: Optional[StrictStr] = None

    storage_serialization_policy: Optional[StrictStr] = None

    __properties = ["base_location", "storage_serialization_policy"]

    @field_validator("storage_serialization_policy")
    def storage_serialization_policy_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("COMPATIBLE", "OPTIMIZED"):
            raise ValueError("must validate the enum values ('COMPATIBLE','OPTIMIZED')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConvertToManagedIcebergTableRequest:
        """Create an instance of ConvertToManagedIcebergTableRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ConvertToManagedIcebergTableRequest:
        """Create an instance of ConvertToManagedIcebergTableRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ConvertToManagedIcebergTableRequest.parse_obj(obj)

        _obj = ConvertToManagedIcebergTableRequest.parse_obj(
            {
                "base_location": obj.get("base_location"),
                "storage_serialization_policy": obj.get("storage_serialization_policy"),
            }
        )

        return _obj


class ConvertToManagedIcebergTableRequestModel:
    def __init__(
        self,  # optional properties
        base_location: Optional[str] = None,
        storage_serialization_policy: Optional[str] = None,
    ):
        """A model object representing the ConvertToManagedIcebergTableRequest resource.

        Constructs an object of type ConvertToManagedIcebergTableRequest with the provided properties.

        Parameters
        __________
        base_location : str, optional
            The path to a directory where Snowflake can write data and metadata files for the table.
        storage_serialization_policy : str, optional
            Specifies the storage serialization policy for the table.
        """
        self.base_location = base_location
        self.storage_serialization_policy = storage_serialization_policy

    __properties = ["base_location", "storage_serialization_policy"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ConvertToManagedIcebergTableRequest(
            base_location=self.base_location,
            storage_serialization_policy=self.storage_serialization_policy,
        )

    @classmethod
    def _from_model(cls, model) -> ConvertToManagedIcebergTableRequestModel:
        return ConvertToManagedIcebergTableRequestModel(
            base_location=model.base_location,
            storage_serialization_policy=model.storage_serialization_policy,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ConvertToManagedIcebergTableRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ConvertToManagedIcebergTableRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ConvertToManagedIcebergTableRequestModel:
        """Create an instance of ConvertToManagedIcebergTableRequest from a dict.

        This method constructs a ConvertToManagedIcebergTableRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ConvertToManagedIcebergTableRequest
            A ConvertToManagedIcebergTableRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ConvertToManagedIcebergTableRequest.from_dict(obj))


ConvertToManagedIcebergTableRequest._model_class = ConvertToManagedIcebergTableRequestModel
