"""
Snowflake Iceberg Table API.

The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.iceberg_table._generated.models.iceberg_table_column import (
    IcebergTableColumn,
    IcebergTableColumnModel,
)


class IcebergTableAsSelect(BaseModel):
    """A model object representing the IcebergTableAsSelect resource.

    Constructs an object of type IcebergTableAsSelect with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the table, must be unique for the schema in which the table is created
    base_location : str
        Specifies the path to a directory where Snowflake can write data and metadata files for the table
    columns : list[IcebergTableColumn], optional

    external_volume : str, optional
        Specifies the name of the external volume to use for the table
    cluster_by : list[str], optional
        Specifies one or more columns or column expressions in the table as the clustering key
    comment : str, optional
        Specifies a comment for the table
    """

    name: StrictStr

    columns: Optional[List[IcebergTableColumn]] = None

    external_volume: Optional[StrictStr] = None

    cluster_by: Optional[List[StrictStr]] = None

    base_location: StrictStr

    comment: Optional[StrictStr] = None

    __properties = ["name", "columns", "external_volume", "cluster_by", "base_location", "comment"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergTableAsSelect:
        """Create an instance of IcebergTableAsSelect from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item in self.columns:
                if _item:
                    _items.append(_item.to_dict())
            _dict["columns"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableAsSelect:
        """Create an instance of IcebergTableAsSelect from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IcebergTableAsSelect.parse_obj(obj)

        _obj = IcebergTableAsSelect.parse_obj(
            {
                "name": obj.get("name"),
                "columns": [IcebergTableColumn.from_dict(_item) for _item in obj.get("columns")]
                if obj.get("columns") is not None
                else None,
                "external_volume": obj.get("external_volume"),
                "cluster_by": obj.get("cluster_by"),
                "base_location": obj.get("base_location"),
                "comment": obj.get("comment"),
            }
        )

        return _obj


class IcebergTableAsSelectModel:
    def __init__(
        self,
        name: str,
        base_location: str,
        # optional properties
        columns: Optional[list[IcebergTableColumn]] = None,
        external_volume: Optional[str] = None,
        cluster_by: Optional[list[str]] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the IcebergTableAsSelect resource.

        Constructs an object of type IcebergTableAsSelect with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the table, must be unique for the schema in which the table is created
        base_location : str
            Specifies the path to a directory where Snowflake can write data and metadata files for the table
        columns : list[IcebergTableColumn], optional

        external_volume : str, optional
            Specifies the name of the external volume to use for the table
        cluster_by : list[str], optional
            Specifies one or more columns or column expressions in the table as the clustering key
        comment : str, optional
            Specifies a comment for the table
        """
        self.name = name
        self.columns = columns
        self.external_volume = external_volume
        self.cluster_by = cluster_by
        self.base_location = base_location
        self.comment = comment

    __properties = ["name", "columns", "external_volume", "cluster_by", "base_location", "comment"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return IcebergTableAsSelect(
            name=self.name,
            columns=[x._to_model() for x in self.columns] if self.columns is not None else None,
            external_volume=self.external_volume,
            cluster_by=self.cluster_by,
            base_location=self.base_location,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> IcebergTableAsSelectModel:
        return IcebergTableAsSelectModel(
            name=model.name,
            columns=[IcebergTableColumnModel._from_model(x) for x in model.columns] if model.columns else None,
            external_volume=model.external_volume,
            cluster_by=model.cluster_by,
            base_location=model.base_location,
            comment=model.comment,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a IcebergTableAsSelect.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the IcebergTableAsSelect object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableAsSelectModel:
        """Create an instance of IcebergTableAsSelect from a dict.

        This method constructs a IcebergTableAsSelect object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        IcebergTableAsSelect
            A IcebergTableAsSelect object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(IcebergTableAsSelect.from_dict(obj))


IcebergTableAsSelect._model_class = IcebergTableAsSelectModel
