"""
Snowflake Iceberg Table API.

The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.iceberg_table._generated.models.point_of_time import PointOfTime, PointOfTimeModel


class IcebergTableClone(BaseModel):
    """A model object representing the IcebergTableClone resource.

    Constructs an object of type IcebergTableClone with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the table, must be unique for the schema in which the table is created
    point_of_time : PointOfTime, optional
    """

    name: StrictStr

    point_of_time: Optional[PointOfTime] = None

    __properties = ["name", "point_of_time"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergTableClone:
        """Create an instance of IcebergTableClone from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of point_of_time
        if self.point_of_time:
            _dict["point_of_time"] = self.point_of_time.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableClone:
        """Create an instance of IcebergTableClone from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IcebergTableClone.parse_obj(obj)

        _obj = IcebergTableClone.parse_obj(
            {
                "name": obj.get("name"),
                "point_of_time": PointOfTime.from_dict(obj.get("point_of_time"))
                if obj.get("point_of_time") is not None
                else None,
            }
        )

        return _obj


class IcebergTableCloneModel:
    def __init__(
        self,
        name: str,
        # optional properties
        point_of_time: Optional[PointOfTime] = None,
    ):
        """A model object representing the IcebergTableClone resource.

        Constructs an object of type IcebergTableClone with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the table, must be unique for the schema in which the table is created
        point_of_time : PointOfTime, optional
        """
        self.name = name
        self.point_of_time = point_of_time

    __properties = ["name", "point_of_time"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return IcebergTableClone(
            name=self.name,
            point_of_time=self.point_of_time._to_model() if self.point_of_time is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> IcebergTableCloneModel:
        return IcebergTableCloneModel(
            name=model.name,
            point_of_time=PointOfTimeModel._from_model(model.point_of_time) if model.point_of_time else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a IcebergTableClone.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the IcebergTableClone object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableCloneModel:
        """Create an instance of IcebergTableClone from a dict.

        This method constructs a IcebergTableClone object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        IcebergTableClone
            A IcebergTableClone object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(IcebergTableClone.from_dict(obj))


IcebergTableClone._model_class = IcebergTableCloneModel
