"""
Snowflake Iceberg Table API.

The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class RefreshIcebergTableRequest(BaseModel):
    """A model object representing the RefreshIcebergTableRequest resource.

    Constructs an object of type RefreshIcebergTableRequest with the provided properties.

    Parameters
    __________
    metadata_file_relative_path : str, optional
        Specifies a metadata file path for a table created from Iceberg files in object storage.
    """

    metadata_file_relative_path: Optional[StrictStr] = None

    __properties = ["metadata_file_relative_path"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RefreshIcebergTableRequest:
        """Create an instance of RefreshIcebergTableRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> RefreshIcebergTableRequest:
        """Create an instance of RefreshIcebergTableRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RefreshIcebergTableRequest.parse_obj(obj)

        _obj = RefreshIcebergTableRequest.parse_obj(
            {
                "metadata_file_relative_path": obj.get("metadata_file_relative_path"),
            }
        )

        return _obj


class RefreshIcebergTableRequestModel:
    def __init__(
        self,  # optional properties
        metadata_file_relative_path: Optional[str] = None,
    ):
        """A model object representing the RefreshIcebergTableRequest resource.

        Constructs an object of type RefreshIcebergTableRequest with the provided properties.

        Parameters
        __________
        metadata_file_relative_path : str, optional
            Specifies a metadata file path for a table created from Iceberg files in object storage.
        """
        self.metadata_file_relative_path = metadata_file_relative_path

    __properties = ["metadata_file_relative_path"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return RefreshIcebergTableRequest(
            metadata_file_relative_path=self.metadata_file_relative_path,
        )

    @classmethod
    def _from_model(cls, model) -> RefreshIcebergTableRequestModel:
        return RefreshIcebergTableRequestModel(
            metadata_file_relative_path=model.metadata_file_relative_path,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a RefreshIcebergTableRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the RefreshIcebergTableRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> RefreshIcebergTableRequestModel:
        """Create an instance of RefreshIcebergTableRequest from a dict.

        This method constructs a RefreshIcebergTableRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        RefreshIcebergTableRequest
            A RefreshIcebergTableRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(RefreshIcebergTableRequest.from_dict(obj))


RefreshIcebergTableRequest._model_class = RefreshIcebergTableRequestModel
