"""
Snowflake Image Repository API.

The Snowflake Image Repository API is a REST API that you can use to access, update, and perform common actions on Image Repository resource in Snowflake.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, Field, StrictStr, field_validator
from typing_extensions import Annotated


class ImageRepository(BaseModel):
    """A model object representing the ImageRepository resource.

    Constructs an object of type ImageRepository with the provided properties.

    Parameters
    __________
    name : str
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    database_name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    schema_name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    created_on : datetime, optional
        Time the image repository was created.
    repository_url : str, optional
        Current URL of the image repository.
    owner : str, optional
        Identifier for the current owner of the image repository.
    owner_role_type : str, optional
        Role type of the image repository owner.
    """

    name: Annotated[str, Field(strict=True)]

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    created_on: Optional[datetime] = None

    repository_url: Optional[StrictStr] = None

    owner: Optional[StrictStr] = None

    owner_role_type: Optional[StrictStr] = None

    __properties = ["name", "database_name", "schema_name", "created_on", "repository_url", "owner", "owner_role_type"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageRepository:
        """Create an instance of ImageRepository from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "repository_url",
                    "owner",
                    "owner_role_type",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ImageRepository:
        """Create an instance of ImageRepository from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ImageRepository.parse_obj(obj)

        _obj = ImageRepository.parse_obj(
            {
                "name": obj.get("name"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "created_on": obj.get("created_on"),
                "repository_url": obj.get("repository_url"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
            }
        )

        return _obj


class ImageRepositoryModel:
    def __init__(
        self,
        name: str,
        # optional properties
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        created_on: Optional[datetime] = None,
        repository_url: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the ImageRepository resource.

        Constructs an object of type ImageRepository with the provided properties.

        Parameters
        __________
        name : str
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        database_name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        schema_name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        created_on : datetime, optional
            Time the image repository was created.
        repository_url : str, optional
            Current URL of the image repository.
        owner : str, optional
            Identifier for the current owner of the image repository.
        owner_role_type : str, optional
            Role type of the image repository owner.
        """
        self.name = name
        self.database_name = database_name
        self.schema_name = schema_name
        self.created_on = created_on
        self.repository_url = repository_url
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = ["name", "database_name", "schema_name", "created_on", "repository_url", "owner", "owner_role_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ImageRepository(
            name=self.name,
            database_name=self.database_name,
            schema_name=self.schema_name,
            created_on=self.created_on,
            repository_url=self.repository_url,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> ImageRepositoryModel:
        return ImageRepositoryModel(
            name=model.name,
            database_name=model.database_name,
            schema_name=model.schema_name,
            created_on=model.created_on,
            repository_url=model.repository_url,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ImageRepository.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ImageRepository object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ImageRepositoryModel:
        """Create an instance of ImageRepository from a dict.

        This method constructs a ImageRepository object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ImageRepository
            A ImageRepository object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ImageRepository.from_dict(obj))


ImageRepository._model_class = ImageRepositoryModel
