"""
Snowflake Notification Integration API.

The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import StrictStr

from snowflake.core.notification_integration._generated.models.notification_hook import (
    NotificationHook,
)


class NotificationQueueAzureEventGridOutbound(NotificationHook):
    """A model object representing the NotificationQueueAzureEventGridOutbound resource.

    Constructs an object of type NotificationQueueAzureEventGridOutbound with the provided properties.

    Parameters
    __________
    azure_event_grid_topic_endpoint : str, optional
        Event Grid topic endpoint to which Snowpipe pushes notifications.
    azure_tenant_id : str, optional
        ID of the Azure Active Directory tenant used for identity management.
    azure_consent_url : str, optional
        URL to the Microsoft permissions request page.
    azure_multi_tenant_app_name : str, optional
        Name of the Snowflake client application created for your account.
    """

    azure_event_grid_topic_endpoint: Optional[StrictStr] = None

    azure_tenant_id: Optional[StrictStr] = None

    azure_consent_url: Optional[StrictStr] = None

    azure_multi_tenant_app_name: Optional[StrictStr] = None

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationQueueAzureEventGridOutbound:
        """Create an instance of NotificationQueueAzureEventGridOutbound from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "azure_consent_url",
                    "azure_multi_tenant_app_name",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["type"] = NotificationHook.get_child_model_discriminator_value("NotificationQueueAzureEventGridOutbound")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationQueueAzureEventGridOutbound:
        """Create an instance of NotificationQueueAzureEventGridOutbound from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NotificationQueueAzureEventGridOutbound.parse_obj(obj)

        _obj = NotificationQueueAzureEventGridOutbound.parse_obj(
            {
                "azure_event_grid_topic_endpoint": obj.get("azure_event_grid_topic_endpoint"),
                "azure_tenant_id": obj.get("azure_tenant_id"),
                "azure_consent_url": obj.get("azure_consent_url"),
                "azure_multi_tenant_app_name": obj.get("azure_multi_tenant_app_name"),
            }
        )

        return _obj


class NotificationQueueAzureEventGridOutboundModel(NotificationHook):
    def __init__(
        self,  # optional properties
        azure_event_grid_topic_endpoint: Optional[str] = None,
        azure_tenant_id: Optional[str] = None,
        azure_consent_url: Optional[str] = None,
        azure_multi_tenant_app_name: Optional[str] = None,
    ):
        """A model object representing the NotificationQueueAzureEventGridOutbound resource.

        Constructs an object of type NotificationQueueAzureEventGridOutbound with the provided properties.

        Parameters
        __________
        azure_event_grid_topic_endpoint : str, optional
            Event Grid topic endpoint to which Snowpipe pushes notifications.
        azure_tenant_id : str, optional
            ID of the Azure Active Directory tenant used for identity management.
        azure_consent_url : str, optional
            URL to the Microsoft permissions request page.
        azure_multi_tenant_app_name : str, optional
            Name of the Snowflake client application created for your account.
        """
        super().__init__()
        self.azure_event_grid_topic_endpoint = azure_event_grid_topic_endpoint
        self.azure_tenant_id = azure_tenant_id
        self.azure_consent_url = azure_consent_url
        self.azure_multi_tenant_app_name = azure_multi_tenant_app_name

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NotificationQueueAzureEventGridOutbound(
            azure_event_grid_topic_endpoint=self.azure_event_grid_topic_endpoint,
            azure_tenant_id=self.azure_tenant_id,
            azure_consent_url=self.azure_consent_url,
            azure_multi_tenant_app_name=self.azure_multi_tenant_app_name,
        )

    @classmethod
    def _from_model(cls, model) -> NotificationQueueAzureEventGridOutboundModel:
        return NotificationQueueAzureEventGridOutboundModel(
            azure_event_grid_topic_endpoint=model.azure_event_grid_topic_endpoint,
            azure_tenant_id=model.azure_tenant_id,
            azure_consent_url=model.azure_consent_url,
            azure_multi_tenant_app_name=model.azure_multi_tenant_app_name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a NotificationQueueAzureEventGridOutbound.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NotificationQueueAzureEventGridOutbound object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationQueueAzureEventGridOutboundModel:
        """Create an instance of NotificationQueueAzureEventGridOutbound from a dict.

        This method constructs a NotificationQueueAzureEventGridOutbound object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NotificationQueueAzureEventGridOutbound
            A NotificationQueueAzureEventGridOutbound object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NotificationQueueAzureEventGridOutbound.from_dict(obj))


NotificationQueueAzureEventGridOutbound._model_class = NotificationQueueAzureEventGridOutboundModel
