"""
Snowflake Procedure API.

The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List

from pydantic import BaseModel

from snowflake.core.procedure._generated.models.call_argument import CallArgument, CallArgumentModel


class CallArgumentList(BaseModel):
    """A model object representing the CallArgumentList resource.

    Constructs an object of type CallArgumentList with the provided properties.

    Parameters
    __________
    call_arguments : list[CallArgument]
        Call Argument list
    """

    call_arguments: List[CallArgument]

    __properties = ["call_arguments"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CallArgumentList:
        """Create an instance of CallArgumentList from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in call_arguments (list)
        _items = []
        if self.call_arguments:
            for _item in self.call_arguments:
                if _item:
                    _items.append(_item.to_dict())
            _dict["call_arguments"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CallArgumentList:
        """Create an instance of CallArgumentList from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CallArgumentList.parse_obj(obj)

        _obj = CallArgumentList.parse_obj(
            {
                "call_arguments": [CallArgument.from_dict(_item) for _item in obj.get("call_arguments")]
                if obj.get("call_arguments") is not None
                else None,
            }
        )

        return _obj


class CallArgumentListModel:
    def __init__(
        self,
        call_arguments: list[CallArgument],
        # optional properties
    ):
        """A model object representing the CallArgumentList resource.

        Constructs an object of type CallArgumentList with the provided properties.

        Parameters
        __________
        call_arguments : list[CallArgument]
            Call Argument list
        """
        self.call_arguments = call_arguments

    __properties = ["call_arguments"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CallArgumentList(
            call_arguments=[x._to_model() for x in self.call_arguments] if self.call_arguments is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> CallArgumentListModel:
        return CallArgumentListModel(
            call_arguments=[CallArgumentModel._from_model(x) for x in model.call_arguments]
            if model.call_arguments
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CallArgumentList.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CallArgumentList object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CallArgumentListModel:
        """Create an instance of CallArgumentList from a dict.

        This method constructs a CallArgumentList object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CallArgumentList
            A CallArgumentList object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CallArgumentList.from_dict(obj))


CallArgumentList._model_class = CallArgumentListModel
