"""
Snowflake Procedure API.

The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import StrictBool, StrictStr, field_validator

from snowflake.core.procedure._generated.models.return_type import ReturnType


class ReturnDataType(ReturnType):
    """A model object representing the ReturnDataType resource.

    Constructs an object of type ReturnDataType with the provided properties.

    Parameters
    __________
    datatype : str
        Return data type
    nullable : bool, optional
        Argument null return acceptance criteria
    """

    datatype: StrictStr

    nullable: Optional[StrictBool] = None

    __properties = ["type"]

    @field_validator("datatype")
    def datatype_validate_enum(cls, v):
        if v not in (
            "ARRAY",
            "BIGINT",
            "BINARY",
            "BOOLEAN",
            "BYTEINT",
            "CHAR",
            "CHARACTER",
            "DATE",
            "DATETIME",
            "DECIMAL",
            "DOUBLE",
            "DOUBLE PRECISION",
            "FLOAT",
            "FLOAT4",
            "FLOAT8",
            "GEOGRAPHY",
            "GEOMETRY",
            "INT",
            "INTEGER",
            "NUMBER",
            "NUMERIC",
            "OBJECT",
            "REAL",
            "STRING",
            "SMALLINT",
            "TEXT",
            "TIME",
            "TIMESTAMP_LTZ",
            "TIMESTAMP_NTZ",
            "TIMESTAMP_TZ",
            "TINYINT",
            "VARBINARY",
            "VARCHAR",
            "VARIANT",
            "VECTOR",
        ):
            raise ValueError(
                "must validate the enum values ('ARRAY','BIGINT','BINARY','BOOLEAN','BYTEINT','CHAR','CHARACTER','DATE','DATETIME','DECIMAL','DOUBLE','DOUBLE PRECISION','FLOAT','FLOAT4','FLOAT8','GEOGRAPHY','GEOMETRY','INT','INTEGER','NUMBER','NUMERIC','OBJECT','REAL','STRING','SMALLINT','TEXT','TIME','TIMESTAMP_LTZ','TIMESTAMP_NTZ','TIMESTAMP_TZ','TINYINT','VARBINARY','VARCHAR','VARIANT','VECTOR')"
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReturnDataType:
        """Create an instance of ReturnDataType from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["type"] = ReturnType.get_child_model_discriminator_value("ReturnDataType")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ReturnDataType:
        """Create an instance of ReturnDataType from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ReturnDataType.parse_obj(obj)

        _obj = ReturnDataType.parse_obj(
            {
                "datatype": obj.get("datatype"),
                "nullable": obj.get("nullable"),
            }
        )

        return _obj


class ReturnDataTypeModel(ReturnType):
    def __init__(
        self,
        datatype: str,
        # optional properties
        nullable: Optional[bool] = None,
    ):
        """A model object representing the ReturnDataType resource.

        Constructs an object of type ReturnDataType with the provided properties.

        Parameters
        __________
        datatype : str
            Return data type
        nullable : bool, optional
            Argument null return acceptance criteria
        """
        super().__init__()
        self.datatype = datatype
        self.nullable = nullable

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ReturnDataType(
            datatype=self.datatype,
            nullable=self.nullable,
        )

    @classmethod
    def _from_model(cls, model) -> ReturnDataTypeModel:
        return ReturnDataTypeModel(
            datatype=model.datatype,
            nullable=model.nullable,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ReturnDataType.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ReturnDataType object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ReturnDataTypeModel:
        """Create an instance of ReturnDataType from a dict.

        This method constructs a ReturnDataType object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ReturnDataType
            A ReturnDataType object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ReturnDataType.from_dict(obj))


ReturnDataType._model_class = ReturnDataTypeModel
