"""
Snowflake Procedure API.

The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from snowflake.core.procedure._generated.models.column_type import ColumnType, ColumnTypeModel
from snowflake.core.procedure._generated.models.return_type import ReturnType


class ReturnTable(ReturnType):
    """A model object representing the ReturnTable resource.

    Constructs an object of type ReturnTable with the provided properties.

    Parameters
    __________
    column_list : list[ColumnType], optional
        List of table columns to return
    """

    column_list: Optional[List[ColumnType]] = None

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReturnTable:
        """Create an instance of ReturnTable from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in column_list (list)
        _items = []
        if self.column_list:
            for _item in self.column_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["column_list"] = _items

        _dict["type"] = ReturnType.get_child_model_discriminator_value("ReturnTable")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ReturnTable:
        """Create an instance of ReturnTable from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ReturnTable.parse_obj(obj)

        _obj = ReturnTable.parse_obj(
            {
                "column_list": [ColumnType.from_dict(_item) for _item in obj.get("column_list")]
                if obj.get("column_list") is not None
                else None,
            }
        )

        return _obj


class ReturnTableModel(ReturnType):
    def __init__(
        self,  # optional properties
        column_list: Optional[list[ColumnType]] = None,
    ):
        """A model object representing the ReturnTable resource.

        Constructs an object of type ReturnTable with the provided properties.

        Parameters
        __________
        column_list : list[ColumnType], optional
            List of table columns to return
        """
        super().__init__()
        self.column_list = column_list

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ReturnTable(
            column_list=[x._to_model() for x in self.column_list] if self.column_list is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> ReturnTableModel:
        return ReturnTableModel(
            column_list=[ColumnTypeModel._from_model(x) for x in model.column_list] if model.column_list else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ReturnTable.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ReturnTable object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ReturnTableModel:
        """Create an instance of ReturnTable from a dict.

        This method constructs a ReturnTable object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ReturnTable
            A ReturnTable object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ReturnTable.from_dict(obj))


ReturnTable._model_class = ReturnTableModel
