"""
Snowflake Services API.

The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, Field, StrictStr


class FetchServiceLogs200Response(BaseModel):
    """A model object representing the FetchServiceLogs200Response resource.

    Constructs an object of type FetchServiceLogs200Response with the provided properties.

    Parameters
    __________
    systemget_service_logs : str, optional
    """

    systemget_service_logs: Optional[StrictStr] = Field(default=None, alias="system$get_service_logs")

    __properties = ["system$get_service_logs"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FetchServiceLogs200Response:
        """Create an instance of FetchServiceLogs200Response from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> FetchServiceLogs200Response:
        """Create an instance of FetchServiceLogs200Response from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FetchServiceLogs200Response.parse_obj(obj)

        _obj = FetchServiceLogs200Response.parse_obj(
            {
                "systemget_service_logs": obj.get("system$get_service_logs"),
            }
        )

        return _obj


class FetchServiceLogs200ResponseModel:
    def __init__(
        self,  # optional properties
        systemget_service_logs: Optional[str] = None,
    ):
        """A model object representing the FetchServiceLogs200Response resource.

        Constructs an object of type FetchServiceLogs200Response with the provided properties.

        Parameters
        __________
        systemget_service_logs : str, optional
        """
        self.systemget_service_logs = systemget_service_logs

    __properties = ["system$get_service_logs"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return FetchServiceLogs200Response(
            systemget_service_logs=self.systemget_service_logs,
        )

    @classmethod
    def _from_model(cls, model) -> FetchServiceLogs200ResponseModel:
        return FetchServiceLogs200ResponseModel(
            systemget_service_logs=model.systemget_service_logs,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a FetchServiceLogs200Response.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the FetchServiceLogs200Response object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> FetchServiceLogs200ResponseModel:
        """Create an instance of FetchServiceLogs200Response from a dict.

        This method constructs a FetchServiceLogs200Response object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        FetchServiceLogs200Response
            A FetchServiceLogs200Response object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(FetchServiceLogs200Response.from_dict(obj))


FetchServiceLogs200Response._model_class = FetchServiceLogs200ResponseModel
