"""
Snowflake Services API.

The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class GrantOf(BaseModel):
    """A model object representing the GrantOf resource.

    Constructs an object of type GrantOf with the provided properties.

    Parameters
    __________
    created_on : datetime, optional
        Date and time when the grant was created
    role : str, optional
        The name of the service role
    granted_to : str, optional
        The type of the grantee, can be USER or ROLE
    grantee_name : str, optional
        The name of the grantee
    granted_by : str, optional
        The name of role that granted the service role to the grantee
    """

    created_on: Optional[datetime] = None

    role: Optional[StrictStr] = None

    granted_to: Optional[StrictStr] = None

    grantee_name: Optional[StrictStr] = None

    granted_by: Optional[StrictStr] = None

    __properties = ["created_on", "role", "granted_to", "grantee_name", "granted_by"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GrantOf:
        """Create an instance of GrantOf from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "role",
                    "granted_to",
                    "grantee_name",
                    "granted_by",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GrantOf:
        """Create an instance of GrantOf from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GrantOf.parse_obj(obj)

        _obj = GrantOf.parse_obj(
            {
                "created_on": obj.get("created_on"),
                "role": obj.get("role"),
                "granted_to": obj.get("granted_to"),
                "grantee_name": obj.get("grantee_name"),
                "granted_by": obj.get("granted_by"),
            }
        )

        return _obj


class GrantOfModel:
    def __init__(
        self,  # optional properties
        created_on: Optional[datetime] = None,
        role: Optional[str] = None,
        granted_to: Optional[str] = None,
        grantee_name: Optional[str] = None,
        granted_by: Optional[str] = None,
    ):
        """A model object representing the GrantOf resource.

        Constructs an object of type GrantOf with the provided properties.

        Parameters
        __________
        created_on : datetime, optional
            Date and time when the grant was created
        role : str, optional
            The name of the service role
        granted_to : str, optional
            The type of the grantee, can be USER or ROLE
        grantee_name : str, optional
            The name of the grantee
        granted_by : str, optional
            The name of role that granted the service role to the grantee
        """
        self.created_on = created_on
        self.role = role
        self.granted_to = granted_to
        self.grantee_name = grantee_name
        self.granted_by = granted_by

    __properties = ["created_on", "role", "granted_to", "grantee_name", "granted_by"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GrantOf(
            created_on=self.created_on,
            role=self.role,
            granted_to=self.granted_to,
            grantee_name=self.grantee_name,
            granted_by=self.granted_by,
        )

    @classmethod
    def _from_model(cls, model) -> GrantOfModel:
        return GrantOfModel(
            created_on=model.created_on,
            role=model.role,
            granted_to=model.granted_to,
            grantee_name=model.grantee_name,
            granted_by=model.granted_by,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GrantOf.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GrantOf object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GrantOfModel:
        """Create an instance of GrantOf from a dict.

        This method constructs a GrantOf object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GrantOf
            A GrantOf object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GrantOf.from_dict(obj))


GrantOf._model_class = GrantOfModel
