"""
Snowflake Services API.

The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.service._generated.models.service_spec import ServiceSpec, ServiceSpecModel


class Service(BaseModel):
    """A model object representing the Service resource.

    Constructs an object of type Service with the provided properties.

    Parameters
    __________
    name : str
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    compute_pool : str
        Specifies the name of the compute pool in your account on which to run the service.
    spec : ServiceSpec

    status : str, optional
        The current status of the service.
    external_access_integrations : list[str], optional
        Specifies the names of the external access integrations that allow your service to access external sites.
    query_warehouse : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    comment : str, optional
        Specifies a comment for the service.
    is_async_job : bool, optional
        True if the service is an async job service; false otherwise.
    auto_resume : bool, optional
        Specifies whether to automatically resume a service when a service function or ingress is called.
    current_instances : int, optional
        The current number of instances for the service.
    target_instances : int, optional
        The target number of service instances that should be running as determined by Snowflake.
    min_ready_instances : int, optional
        The minimum number of ready service instances to declare the service as READY.
    min_instances : int, optional
        Specifies the minimum number of service instances to run.
    max_instances : int, optional
        Specifies the maximum number of service instances to run.
    database_name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    schema_name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    owner : str, optional
        Role that owns the service.
    dns_name : str, optional
        Snowflake-assiged DNS name of the service. The DNS name enables service-to-service communications.
    created_on : datetime, optional
        Timestamp when the service was created.
    updated_on : datetime, optional
        Timestamp when the service was last updated.
    resumed_on : datetime, optional
        Timestamp when the service was last resumed.
    suspended_on : datetime, optional
        Timestamp when the service was last suspended.
    auto_suspend_secs : int, optional
        Number of seconds of inactivity after which the service will be automatically suspended. The default value is 0 which represents the service will not be automatically suspended.
    owner_role_type : str, optional
        The role type of the service owner.
    is_job : bool, optional
        True if the service is a job service; false otherwise.
    spec_digest : str, optional
        The unique and immutable identifier representing the service spec content.
    is_upgrading : bool, optional
        TRUE, if Snowflake is in the process of upgrading the service.
    managing_object_domain : str, optional
        The domain of the managing object (for example, the domain of the notebook that manages the service). NULL if the service is not managed by a Snowflake entity.
    managing_object_name : str, optional
        The name of the managing object (for example, the name of the notebook that manages the service). NULL if the service is not managed by a Snowflake entity.
    """

    name: Annotated[str, Field(strict=True)]

    status: Optional[StrictStr] = None

    compute_pool: StrictStr

    spec: ServiceSpec

    external_access_integrations: Optional[List[StrictStr]] = None

    query_warehouse: Optional[Annotated[str, Field(strict=True)]] = None

    comment: Optional[StrictStr] = None

    is_async_job: Optional[StrictBool] = None

    auto_resume: Optional[StrictBool] = None

    current_instances: Optional[StrictInt] = None

    target_instances: Optional[StrictInt] = None

    min_ready_instances: Optional[StrictInt] = None

    min_instances: Optional[StrictInt] = None

    max_instances: Optional[StrictInt] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    owner: Optional[StrictStr] = None

    dns_name: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    updated_on: Optional[datetime] = None

    resumed_on: Optional[datetime] = None

    suspended_on: Optional[datetime] = None

    auto_suspend_secs: Optional[StrictInt] = None

    owner_role_type: Optional[StrictStr] = None

    is_job: Optional[StrictBool] = None

    spec_digest: Optional[StrictStr] = None

    is_upgrading: Optional[StrictBool] = None

    managing_object_domain: Optional[StrictStr] = None

    managing_object_name: Optional[StrictStr] = None

    __properties = [
        "name",
        "status",
        "compute_pool",
        "spec",
        "external_access_integrations",
        "query_warehouse",
        "comment",
        "is_async_job",
        "auto_resume",
        "current_instances",
        "target_instances",
        "min_ready_instances",
        "min_instances",
        "max_instances",
        "database_name",
        "schema_name",
        "owner",
        "dns_name",
        "created_on",
        "updated_on",
        "resumed_on",
        "suspended_on",
        "auto_suspend_secs",
        "owner_role_type",
        "is_job",
        "spec_digest",
        "is_upgrading",
        "managing_object_domain",
        "managing_object_name",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("query_warehouse")
    def query_warehouse_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Service:
        """Create an instance of Service from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "current_instances",
                    "target_instances",
                    "owner",
                    "dns_name",
                    "created_on",
                    "updated_on",
                    "resumed_on",
                    "suspended_on",
                    "owner_role_type",
                    "is_job",
                    "spec_digest",
                    "is_upgrading",
                    "managing_object_domain",
                    "managing_object_name",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of spec
        if self.spec:
            _dict["spec"] = self.spec.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Service:
        """Create an instance of Service from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Service.parse_obj(obj)

        _obj = Service.parse_obj(
            {
                "name": obj.get("name"),
                "status": obj.get("status"),
                "compute_pool": obj.get("compute_pool"),
                "spec": ServiceSpec.from_dict(obj.get("spec")) if obj.get("spec") is not None else None,
                "external_access_integrations": obj.get("external_access_integrations"),
                "query_warehouse": obj.get("query_warehouse"),
                "comment": obj.get("comment"),
                "is_async_job": obj.get("is_async_job"),
                "auto_resume": obj.get("auto_resume"),
                "current_instances": obj.get("current_instances"),
                "target_instances": obj.get("target_instances"),
                "min_ready_instances": obj.get("min_ready_instances"),
                "min_instances": obj.get("min_instances"),
                "max_instances": obj.get("max_instances"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "dns_name": obj.get("dns_name"),
                "created_on": obj.get("created_on"),
                "updated_on": obj.get("updated_on"),
                "resumed_on": obj.get("resumed_on"),
                "suspended_on": obj.get("suspended_on"),
                "auto_suspend_secs": obj.get("auto_suspend_secs"),
                "owner_role_type": obj.get("owner_role_type"),
                "is_job": obj.get("is_job"),
                "spec_digest": obj.get("spec_digest"),
                "is_upgrading": obj.get("is_upgrading"),
                "managing_object_domain": obj.get("managing_object_domain"),
                "managing_object_name": obj.get("managing_object_name"),
            }
        )

        return _obj


class ServiceModel:
    def __init__(
        self,
        name: str,
        compute_pool: str,
        spec: ServiceSpec,
        # optional properties
        status: Optional[str] = None,
        external_access_integrations: Optional[list[str]] = None,
        query_warehouse: Optional[str] = None,
        comment: Optional[str] = None,
        is_async_job: Optional[bool] = None,
        auto_resume: Optional[bool] = None,
        current_instances: Optional[int] = None,
        target_instances: Optional[int] = None,
        min_ready_instances: Optional[int] = None,
        min_instances: Optional[int] = None,
        max_instances: Optional[int] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        dns_name: Optional[str] = None,
        created_on: Optional[datetime] = None,
        updated_on: Optional[datetime] = None,
        resumed_on: Optional[datetime] = None,
        suspended_on: Optional[datetime] = None,
        auto_suspend_secs: Optional[int] = None,
        owner_role_type: Optional[str] = None,
        is_job: Optional[bool] = None,
        spec_digest: Optional[str] = None,
        is_upgrading: Optional[bool] = None,
        managing_object_domain: Optional[str] = None,
        managing_object_name: Optional[str] = None,
    ):
        """A model object representing the Service resource.

        Constructs an object of type Service with the provided properties.

        Parameters
        __________
        name : str
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        compute_pool : str
            Specifies the name of the compute pool in your account on which to run the service.
        spec : ServiceSpec

        status : str, optional
            The current status of the service.
        external_access_integrations : list[str], optional
            Specifies the names of the external access integrations that allow your service to access external sites.
        query_warehouse : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        comment : str, optional
            Specifies a comment for the service.
        is_async_job : bool, optional
            True if the service is an async job service; false otherwise.
        auto_resume : bool, optional
            Specifies whether to automatically resume a service when a service function or ingress is called.
        current_instances : int, optional
            The current number of instances for the service.
        target_instances : int, optional
            The target number of service instances that should be running as determined by Snowflake.
        min_ready_instances : int, optional
            The minimum number of ready service instances to declare the service as READY.
        min_instances : int, optional
            Specifies the minimum number of service instances to run.
        max_instances : int, optional
            Specifies the maximum number of service instances to run.
        database_name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        schema_name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        owner : str, optional
            Role that owns the service.
        dns_name : str, optional
            Snowflake-assiged DNS name of the service. The DNS name enables service-to-service communications.
        created_on : datetime, optional
            Timestamp when the service was created.
        updated_on : datetime, optional
            Timestamp when the service was last updated.
        resumed_on : datetime, optional
            Timestamp when the service was last resumed.
        suspended_on : datetime, optional
            Timestamp when the service was last suspended.
        auto_suspend_secs : int, optional
            Number of seconds of inactivity after which the service will be automatically suspended. The default value is 0 which represents the service will not be automatically suspended.
        owner_role_type : str, optional
            The role type of the service owner.
        is_job : bool, optional
            True if the service is a job service; false otherwise.
        spec_digest : str, optional
            The unique and immutable identifier representing the service spec content.
        is_upgrading : bool, optional
            TRUE, if Snowflake is in the process of upgrading the service.
        managing_object_domain : str, optional
            The domain of the managing object (for example, the domain of the notebook that manages the service). NULL if the service is not managed by a Snowflake entity.
        managing_object_name : str, optional
            The name of the managing object (for example, the name of the notebook that manages the service). NULL if the service is not managed by a Snowflake entity.
        """
        self.name = name
        self.status = status
        self.compute_pool = compute_pool
        self.spec = spec
        self.external_access_integrations = external_access_integrations
        self.query_warehouse = query_warehouse
        self.comment = comment
        self.is_async_job = is_async_job
        self.auto_resume = auto_resume
        self.current_instances = current_instances
        self.target_instances = target_instances
        self.min_ready_instances = min_ready_instances
        self.min_instances = min_instances
        self.max_instances = max_instances
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.dns_name = dns_name
        self.created_on = created_on
        self.updated_on = updated_on
        self.resumed_on = resumed_on
        self.suspended_on = suspended_on
        self.auto_suspend_secs = auto_suspend_secs
        self.owner_role_type = owner_role_type
        self.is_job = is_job
        self.spec_digest = spec_digest
        self.is_upgrading = is_upgrading
        self.managing_object_domain = managing_object_domain
        self.managing_object_name = managing_object_name

    __properties = [
        "name",
        "status",
        "compute_pool",
        "spec",
        "external_access_integrations",
        "query_warehouse",
        "comment",
        "is_async_job",
        "auto_resume",
        "current_instances",
        "target_instances",
        "min_ready_instances",
        "min_instances",
        "max_instances",
        "database_name",
        "schema_name",
        "owner",
        "dns_name",
        "created_on",
        "updated_on",
        "resumed_on",
        "suspended_on",
        "auto_suspend_secs",
        "owner_role_type",
        "is_job",
        "spec_digest",
        "is_upgrading",
        "managing_object_domain",
        "managing_object_name",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Service(
            name=self.name,
            status=self.status,
            compute_pool=self.compute_pool,
            spec=self.spec._to_model() if self.spec is not None else None,
            external_access_integrations=self.external_access_integrations,
            query_warehouse=self.query_warehouse,
            comment=self.comment,
            is_async_job=self.is_async_job,
            auto_resume=self.auto_resume,
            current_instances=self.current_instances,
            target_instances=self.target_instances,
            min_ready_instances=self.min_ready_instances,
            min_instances=self.min_instances,
            max_instances=self.max_instances,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            dns_name=self.dns_name,
            created_on=self.created_on,
            updated_on=self.updated_on,
            resumed_on=self.resumed_on,
            suspended_on=self.suspended_on,
            auto_suspend_secs=self.auto_suspend_secs,
            owner_role_type=self.owner_role_type,
            is_job=self.is_job,
            spec_digest=self.spec_digest,
            is_upgrading=self.is_upgrading,
            managing_object_domain=self.managing_object_domain,
            managing_object_name=self.managing_object_name,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceModel:
        return ServiceModel(
            name=model.name,
            status=model.status,
            compute_pool=model.compute_pool,
            spec=ServiceSpecModel._from_model(model.spec) if model.spec else None,
            external_access_integrations=model.external_access_integrations,
            query_warehouse=model.query_warehouse,
            comment=model.comment,
            is_async_job=model.is_async_job,
            auto_resume=model.auto_resume,
            current_instances=model.current_instances,
            target_instances=model.target_instances,
            min_ready_instances=model.min_ready_instances,
            min_instances=model.min_instances,
            max_instances=model.max_instances,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            dns_name=model.dns_name,
            created_on=model.created_on,
            updated_on=model.updated_on,
            resumed_on=model.resumed_on,
            suspended_on=model.suspended_on,
            auto_suspend_secs=model.auto_suspend_secs,
            owner_role_type=model.owner_role_type,
            is_job=model.is_job,
            spec_digest=model.spec_digest,
            is_upgrading=model.is_upgrading,
            managing_object_domain=model.managing_object_domain,
            managing_object_name=model.managing_object_name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Service.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Service object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceModel:
        """Create an instance of Service from a dict.

        This method constructs a Service object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Service
            A Service object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Service.from_dict(obj))


Service._model_class = ServiceModel
