"""
Snowflake Services API.

The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr


class ServiceEndpoint(BaseModel):
    """A model object representing the ServiceEndpoint resource.

    Constructs an object of type ServiceEndpoint with the provided properties.

    Parameters
    __________
    name : str, optional
        User-friendly endpoint name that represents the corresponding port.
    port : int, optional
        The network port the service is listening on. NULL, when portRange is specified.
    port_range : str, optional
        The network port range the service is listening on. NULL, when port is specified.
    protocol : str,  default 'HTTP'
        Supported network protocol (TCP, HTTP, or HTTPS).
    is_public : bool,  default False
        True, if the endpoint is public, accessible from internet.
    ingress_url : str, optional
        Endpoint URL accessible from the internet.
    """

    name: Optional[StrictStr] = None

    port: Optional[StrictInt] = None

    port_range: Optional[StrictStr] = Field(default=None, alias="portRange")

    protocol: Optional[StrictStr] = "HTTP"

    is_public: Optional[StrictBool] = False

    ingress_url: Optional[StrictStr] = None

    __properties = ["name", "port", "portRange", "protocol", "is_public", "ingress_url"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceEndpoint:
        """Create an instance of ServiceEndpoint from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "ingress_url",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceEndpoint:
        """Create an instance of ServiceEndpoint from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceEndpoint.parse_obj(obj)

        _obj = ServiceEndpoint.parse_obj(
            {
                "name": obj.get("name"),
                "port": obj.get("port"),
                "port_range": obj.get("portRange"),
                "protocol": obj.get("protocol") if obj.get("protocol") is not None else "HTTP",
                "is_public": obj.get("is_public") if obj.get("is_public") is not None else False,
                "ingress_url": obj.get("ingress_url"),
            }
        )

        return _obj


class ServiceEndpointModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        port: Optional[int] = None,
        port_range: Optional[str] = None,
        protocol: Optional[str] = "HTTP",
        is_public: Optional[bool] = False,
        ingress_url: Optional[str] = None,
    ):
        """A model object representing the ServiceEndpoint resource.

        Constructs an object of type ServiceEndpoint with the provided properties.

        Parameters
        __________
        name : str, optional
            User-friendly endpoint name that represents the corresponding port.
        port : int, optional
            The network port the service is listening on. NULL, when portRange is specified.
        port_range : str, optional
            The network port range the service is listening on. NULL, when port is specified.
        protocol : str,  default 'HTTP'
            Supported network protocol (TCP, HTTP, or HTTPS).
        is_public : bool,  default False
            True, if the endpoint is public, accessible from internet.
        ingress_url : str, optional
            Endpoint URL accessible from the internet.
        """
        self.name = name
        self.port = port
        self.port_range = port_range
        self.protocol = protocol
        self.is_public = is_public
        self.ingress_url = ingress_url

    __properties = ["name", "port", "portRange", "protocol", "is_public", "ingress_url"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceEndpoint(
            name=self.name,
            port=self.port,
            port_range=self.port_range,
            protocol=self.protocol,
            is_public=self.is_public,
            ingress_url=self.ingress_url,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceEndpointModel:
        return ServiceEndpointModel(
            name=model.name,
            port=model.port,
            port_range=model.port_range,
            protocol=model.protocol,
            is_public=model.is_public,
            ingress_url=model.ingress_url,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ServiceEndpoint.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceEndpoint object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceEndpointModel:
        """Create an instance of ServiceEndpoint from a dict.

        This method constructs a ServiceEndpoint object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceEndpoint
            A ServiceEndpoint object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceEndpoint.from_dict(obj))


ServiceEndpoint._model_class = ServiceEndpointModel
